<?php
// This file was auto-generated from sdk-root/src/data/bedrock-agentcore-control/2023-06-05/api-2.json
return [ 'version' => '2.0', 'metadata' => [ 'apiVersion' => '2023-06-05', 'auth' => [ 'aws.auth#sigv4', ], 'endpointPrefix' => 'bedrock-agentcore-control', 'protocol' => 'rest-json', 'protocols' => [ 'rest-json', ], 'serviceFullName' => 'Amazon Bedrock AgentCore Control', 'serviceId' => 'Bedrock AgentCore Control', 'signatureVersion' => 'v4', 'signingName' => 'bedrock-agentcore', 'uid' => 'bedrock-agentcore-control-2023-06-05', ], 'operations' => [ 'CreateAgentRuntime' => [ 'name' => 'CreateAgentRuntime', 'http' => [ 'method' => 'PUT', 'requestUri' => '/runtimes/', 'responseCode' => 202, ], 'input' => [ 'shape' => 'CreateAgentRuntimeRequest', ], 'output' => [ 'shape' => 'CreateAgentRuntimeResponse', ], 'errors' => [ [ 'shape' => 'ServiceQuotaExceededException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], 'idempotent' => true, ], 'CreateAgentRuntimeEndpoint' => [ 'name' => 'CreateAgentRuntimeEndpoint', 'http' => [ 'method' => 'PUT', 'requestUri' => '/runtimes/{agentRuntimeId}/runtime-endpoints/', 'responseCode' => 202, ], 'input' => [ 'shape' => 'CreateAgentRuntimeEndpointRequest', ], 'output' => [ 'shape' => 'CreateAgentRuntimeEndpointResponse', ], 'errors' => [ [ 'shape' => 'ServiceQuotaExceededException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], 'idempotent' => true, ], 'CreateApiKeyCredentialProvider' => [ 'name' => 'CreateApiKeyCredentialProvider', 'http' => [ 'method' => 'POST', 'requestUri' => '/identities/CreateApiKeyCredentialProvider', 'responseCode' => 201, ], 'input' => [ 'shape' => 'CreateApiKeyCredentialProviderRequest', ], 'output' => [ 'shape' => 'CreateApiKeyCredentialProviderResponse', ], 'errors' => [ [ 'shape' => 'ServiceQuotaExceededException', ], [ 'shape' => 'UnauthorizedException', ], [ 'shape' => 'ResourceLimitExceededException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'DecryptionFailure', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'EncryptionFailure', ], ], 'idempotent' => true, ], 'CreateBrowser' => [ 'name' => 'CreateBrowser', 'http' => [ 'method' => 'PUT', 'requestUri' => '/browsers', 'responseCode' => 202, ], 'input' => [ 'shape' => 'CreateBrowserRequest', ], 'output' => [ 'shape' => 'CreateBrowserResponse', ], 'errors' => [ [ 'shape' => 'ServiceQuotaExceededException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], 'idempotent' => true, ], 'CreateCodeInterpreter' => [ 'name' => 'CreateCodeInterpreter', 'http' => [ 'method' => 'PUT', 'requestUri' => '/code-interpreters', 'responseCode' => 202, ], 'input' => [ 'shape' => 'CreateCodeInterpreterRequest', ], 'output' => [ 'shape' => 'CreateCodeInterpreterResponse', ], 'errors' => [ [ 'shape' => 'ServiceQuotaExceededException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], 'idempotent' => true, ], 'CreateGateway' => [ 'name' => 'CreateGateway', 'http' => [ 'method' => 'POST', 'requestUri' => '/gateways/', 'responseCode' => 202, ], 'input' => [ 'shape' => 'CreateGatewayRequest', ], 'output' => [ 'shape' => 'CreateGatewayResponse', ], 'errors' => [ [ 'shape' => 'ServiceQuotaExceededException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], 'idempotent' => true, ], 'CreateGatewayTarget' => [ 'name' => 'CreateGatewayTarget', 'http' => [ 'method' => 'POST', 'requestUri' => '/gateways/{gatewayIdentifier}/targets/', 'responseCode' => 202, ], 'input' => [ 'shape' => 'CreateGatewayTargetRequest', ], 'output' => [ 'shape' => 'CreateGatewayTargetResponse', ], 'errors' => [ [ 'shape' => 'ServiceQuotaExceededException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InternalServerException', ], ], 'idempotent' => true, ], 'CreateMemory' => [ 'name' => 'CreateMemory', 'http' => [ 'method' => 'POST', 'requestUri' => '/memories/create', 'responseCode' => 202, ], 'input' => [ 'shape' => 'CreateMemoryInput', ], 'output' => [ 'shape' => 'CreateMemoryOutput', ], 'errors' => [ [ 'shape' => 'ServiceQuotaExceededException', ], [ 'shape' => 'ServiceException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottledException', ], ], 'idempotent' => true, ], 'CreateOauth2CredentialProvider' => [ 'name' => 'CreateOauth2CredentialProvider', 'http' => [ 'method' => 'POST', 'requestUri' => '/identities/CreateOauth2CredentialProvider', 'responseCode' => 201, ], 'input' => [ 'shape' => 'CreateOauth2CredentialProviderRequest', ], 'output' => [ 'shape' => 'CreateOauth2CredentialProviderResponse', ], 'errors' => [ [ 'shape' => 'ServiceQuotaExceededException', ], [ 'shape' => 'UnauthorizedException', ], [ 'shape' => 'ResourceLimitExceededException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'DecryptionFailure', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'EncryptionFailure', ], ], 'idempotent' => true, ], 'CreateWorkloadIdentity' => [ 'name' => 'CreateWorkloadIdentity', 'http' => [ 'method' => 'POST', 'requestUri' => '/identities/CreateWorkloadIdentity', 'responseCode' => 201, ], 'input' => [ 'shape' => 'CreateWorkloadIdentityRequest', ], 'output' => [ 'shape' => 'CreateWorkloadIdentityResponse', ], 'errors' => [ [ 'shape' => 'UnauthorizedException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], 'idempotent' => true, ], 'DeleteAgentRuntime' => [ 'name' => 'DeleteAgentRuntime', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/runtimes/{agentRuntimeId}/', 'responseCode' => 202, ], 'input' => [ 'shape' => 'DeleteAgentRuntimeRequest', ], 'output' => [ 'shape' => 'DeleteAgentRuntimeResponse', ], 'errors' => [ [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], 'idempotent' => true, ], 'DeleteAgentRuntimeEndpoint' => [ 'name' => 'DeleteAgentRuntimeEndpoint', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/runtimes/{agentRuntimeId}/runtime-endpoints/{endpointName}/', 'responseCode' => 202, ], 'input' => [ 'shape' => 'DeleteAgentRuntimeEndpointRequest', ], 'output' => [ 'shape' => 'DeleteAgentRuntimeEndpointResponse', ], 'errors' => [ [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], 'idempotent' => true, ], 'DeleteApiKeyCredentialProvider' => [ 'name' => 'DeleteApiKeyCredentialProvider', 'http' => [ 'method' => 'POST', 'requestUri' => '/identities/DeleteApiKeyCredentialProvider', 'responseCode' => 204, ], 'input' => [ 'shape' => 'DeleteApiKeyCredentialProviderRequest', ], 'output' => [ 'shape' => 'DeleteApiKeyCredentialProviderResponse', ], 'errors' => [ [ 'shape' => 'UnauthorizedException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], 'idempotent' => true, ], 'DeleteBrowser' => [ 'name' => 'DeleteBrowser', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/browsers/{browserId}', 'responseCode' => 202, ], 'input' => [ 'shape' => 'DeleteBrowserRequest', ], 'output' => [ 'shape' => 'DeleteBrowserResponse', ], 'errors' => [ [ 'shape' => 'ServiceQuotaExceededException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], 'idempotent' => true, ], 'DeleteCodeInterpreter' => [ 'name' => 'DeleteCodeInterpreter', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/code-interpreters/{codeInterpreterId}', 'responseCode' => 202, ], 'input' => [ 'shape' => 'DeleteCodeInterpreterRequest', ], 'output' => [ 'shape' => 'DeleteCodeInterpreterResponse', ], 'errors' => [ [ 'shape' => 'ServiceQuotaExceededException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], 'idempotent' => true, ], 'DeleteGateway' => [ 'name' => 'DeleteGateway', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/gateways/{gatewayIdentifier}/', 'responseCode' => 202, ], 'input' => [ 'shape' => 'DeleteGatewayRequest', ], 'output' => [ 'shape' => 'DeleteGatewayResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], 'idempotent' => true, ], 'DeleteGatewayTarget' => [ 'name' => 'DeleteGatewayTarget', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/gateways/{gatewayIdentifier}/targets/{targetId}/', 'responseCode' => 202, ], 'input' => [ 'shape' => 'DeleteGatewayTargetRequest', ], 'output' => [ 'shape' => 'DeleteGatewayTargetResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], 'idempotent' => true, ], 'DeleteMemory' => [ 'name' => 'DeleteMemory', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/memories/{memoryId}/delete', 'responseCode' => 202, ], 'input' => [ 'shape' => 'DeleteMemoryInput', ], 'output' => [ 'shape' => 'DeleteMemoryOutput', ], 'errors' => [ [ 'shape' => 'ServiceException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottledException', ], ], 'idempotent' => true, ], 'DeleteOauth2CredentialProvider' => [ 'name' => 'DeleteOauth2CredentialProvider', 'http' => [ 'method' => 'POST', 'requestUri' => '/identities/DeleteOauth2CredentialProvider', 'responseCode' => 204, ], 'input' => [ 'shape' => 'DeleteOauth2CredentialProviderRequest', ], 'output' => [ 'shape' => 'DeleteOauth2CredentialProviderResponse', ], 'errors' => [ [ 'shape' => 'UnauthorizedException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], 'idempotent' => true, ], 'DeleteWorkloadIdentity' => [ 'name' => 'DeleteWorkloadIdentity', 'http' => [ 'method' => 'POST', 'requestUri' => '/identities/DeleteWorkloadIdentity', 'responseCode' => 204, ], 'input' => [ 'shape' => 'DeleteWorkloadIdentityRequest', ], 'output' => [ 'shape' => 'DeleteWorkloadIdentityResponse', ], 'errors' => [ [ 'shape' => 'UnauthorizedException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], 'idempotent' => true, ], 'GetAgentRuntime' => [ 'name' => 'GetAgentRuntime', 'http' => [ 'method' => 'GET', 'requestUri' => '/runtimes/{agentRuntimeId}/', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetAgentRuntimeRequest', ], 'output' => [ 'shape' => 'GetAgentRuntimeResponse', ], 'errors' => [ [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], 'readonly' => true, ], 'GetAgentRuntimeEndpoint' => [ 'name' => 'GetAgentRuntimeEndpoint', 'http' => [ 'method' => 'GET', 'requestUri' => '/runtimes/{agentRuntimeId}/runtime-endpoints/{endpointName}/', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetAgentRuntimeEndpointRequest', ], 'output' => [ 'shape' => 'GetAgentRuntimeEndpointResponse', ], 'errors' => [ [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], 'readonly' => true, ], 'GetApiKeyCredentialProvider' => [ 'name' => 'GetApiKeyCredentialProvider', 'http' => [ 'method' => 'POST', 'requestUri' => '/identities/GetApiKeyCredentialProvider', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetApiKeyCredentialProviderRequest', ], 'output' => [ 'shape' => 'GetApiKeyCredentialProviderResponse', ], 'errors' => [ [ 'shape' => 'UnauthorizedException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'DecryptionFailure', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], 'readonly' => true, ], 'GetBrowser' => [ 'name' => 'GetBrowser', 'http' => [ 'method' => 'GET', 'requestUri' => '/browsers/{browserId}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetBrowserRequest', ], 'output' => [ 'shape' => 'GetBrowserResponse', ], 'errors' => [ [ 'shape' => 'ServiceQuotaExceededException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], 'readonly' => true, ], 'GetCodeInterpreter' => [ 'name' => 'GetCodeInterpreter', 'http' => [ 'method' => 'GET', 'requestUri' => '/code-interpreters/{codeInterpreterId}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetCodeInterpreterRequest', ], 'output' => [ 'shape' => 'GetCodeInterpreterResponse', ], 'errors' => [ [ 'shape' => 'ServiceQuotaExceededException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], 'readonly' => true, ], 'GetGateway' => [ 'name' => 'GetGateway', 'http' => [ 'method' => 'GET', 'requestUri' => '/gateways/{gatewayIdentifier}/', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetGatewayRequest', ], 'output' => [ 'shape' => 'GetGatewayResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], 'readonly' => true, ], 'GetGatewayTarget' => [ 'name' => 'GetGatewayTarget', 'http' => [ 'method' => 'GET', 'requestUri' => '/gateways/{gatewayIdentifier}/targets/{targetId}/', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetGatewayTargetRequest', ], 'output' => [ 'shape' => 'GetGatewayTargetResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], 'readonly' => true, ], 'GetMemory' => [ 'name' => 'GetMemory', 'http' => [ 'method' => 'GET', 'requestUri' => '/memories/{memoryId}/details', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetMemoryInput', ], 'output' => [ 'shape' => 'GetMemoryOutput', ], 'errors' => [ [ 'shape' => 'ServiceException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottledException', ], ], 'readonly' => true, ], 'GetOauth2CredentialProvider' => [ 'name' => 'GetOauth2CredentialProvider', 'http' => [ 'method' => 'POST', 'requestUri' => '/identities/GetOauth2CredentialProvider', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetOauth2CredentialProviderRequest', ], 'output' => [ 'shape' => 'GetOauth2CredentialProviderResponse', ], 'errors' => [ [ 'shape' => 'UnauthorizedException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'DecryptionFailure', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], 'readonly' => true, ], 'GetTokenVault' => [ 'name' => 'GetTokenVault', 'http' => [ 'method' => 'POST', 'requestUri' => '/identities/get-token-vault', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetTokenVaultRequest', ], 'output' => [ 'shape' => 'GetTokenVaultResponse', ], 'errors' => [ [ 'shape' => 'UnauthorizedException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], 'readonly' => true, ], 'GetWorkloadIdentity' => [ 'name' => 'GetWorkloadIdentity', 'http' => [ 'method' => 'POST', 'requestUri' => '/identities/GetWorkloadIdentity', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetWorkloadIdentityRequest', ], 'output' => [ 'shape' => 'GetWorkloadIdentityResponse', ], 'errors' => [ [ 'shape' => 'UnauthorizedException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], 'readonly' => true, ], 'ListAgentRuntimeEndpoints' => [ 'name' => 'ListAgentRuntimeEndpoints', 'http' => [ 'method' => 'POST', 'requestUri' => '/runtimes/{agentRuntimeId}/runtime-endpoints/', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListAgentRuntimeEndpointsRequest', ], 'output' => [ 'shape' => 'ListAgentRuntimeEndpointsResponse', ], 'errors' => [ [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], 'readonly' => true, ], 'ListAgentRuntimeVersions' => [ 'name' => 'ListAgentRuntimeVersions', 'http' => [ 'method' => 'POST', 'requestUri' => '/runtimes/{agentRuntimeId}/versions/', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListAgentRuntimeVersionsRequest', ], 'output' => [ 'shape' => 'ListAgentRuntimeVersionsResponse', ], 'errors' => [ [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], 'readonly' => true, ], 'ListAgentRuntimes' => [ 'name' => 'ListAgentRuntimes', 'http' => [ 'method' => 'POST', 'requestUri' => '/runtimes/', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListAgentRuntimesRequest', ], 'output' => [ 'shape' => 'ListAgentRuntimesResponse', ], 'errors' => [ [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], 'readonly' => true, ], 'ListApiKeyCredentialProviders' => [ 'name' => 'ListApiKeyCredentialProviders', 'http' => [ 'method' => 'POST', 'requestUri' => '/identities/ListApiKeyCredentialProviders', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListApiKeyCredentialProvidersRequest', ], 'output' => [ 'shape' => 'ListApiKeyCredentialProvidersResponse', ], 'errors' => [ [ 'shape' => 'UnauthorizedException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], 'readonly' => true, ], 'ListBrowsers' => [ 'name' => 'ListBrowsers', 'http' => [ 'method' => 'POST', 'requestUri' => '/browsers', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListBrowsersRequest', ], 'output' => [ 'shape' => 'ListBrowsersResponse', ], 'errors' => [ [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], 'readonly' => true, ], 'ListCodeInterpreters' => [ 'name' => 'ListCodeInterpreters', 'http' => [ 'method' => 'POST', 'requestUri' => '/code-interpreters', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListCodeInterpretersRequest', ], 'output' => [ 'shape' => 'ListCodeInterpretersResponse', ], 'errors' => [ [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], 'readonly' => true, ], 'ListGatewayTargets' => [ 'name' => 'ListGatewayTargets', 'http' => [ 'method' => 'GET', 'requestUri' => '/gateways/{gatewayIdentifier}/targets/', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListGatewayTargetsRequest', ], 'output' => [ 'shape' => 'ListGatewayTargetsResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], 'readonly' => true, ], 'ListGateways' => [ 'name' => 'ListGateways', 'http' => [ 'method' => 'GET', 'requestUri' => '/gateways/', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListGatewaysRequest', ], 'output' => [ 'shape' => 'ListGatewaysResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], 'readonly' => true, ], 'ListMemories' => [ 'name' => 'ListMemories', 'http' => [ 'method' => 'POST', 'requestUri' => '/memories/', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListMemoriesInput', ], 'output' => [ 'shape' => 'ListMemoriesOutput', ], 'errors' => [ [ 'shape' => 'ServiceException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottledException', ], ], 'readonly' => true, ], 'ListOauth2CredentialProviders' => [ 'name' => 'ListOauth2CredentialProviders', 'http' => [ 'method' => 'POST', 'requestUri' => '/identities/ListOauth2CredentialProviders', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListOauth2CredentialProvidersRequest', ], 'output' => [ 'shape' => 'ListOauth2CredentialProvidersResponse', ], 'errors' => [ [ 'shape' => 'UnauthorizedException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], 'readonly' => true, ], 'ListTagsForResource' => [ 'name' => 'ListTagsForResource', 'http' => [ 'method' => 'GET', 'requestUri' => '/tags/{resourceArn}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListTagsForResourceRequest', ], 'output' => [ 'shape' => 'ListTagsForResourceResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], 'readonly' => true, ], 'ListWorkloadIdentities' => [ 'name' => 'ListWorkloadIdentities', 'http' => [ 'method' => 'POST', 'requestUri' => '/identities/ListWorkloadIdentities', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListWorkloadIdentitiesRequest', ], 'output' => [ 'shape' => 'ListWorkloadIdentitiesResponse', ], 'errors' => [ [ 'shape' => 'UnauthorizedException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], 'readonly' => true, ], 'SetTokenVaultCMK' => [ 'name' => 'SetTokenVaultCMK', 'http' => [ 'method' => 'POST', 'requestUri' => '/identities/set-token-vault-cmk', 'responseCode' => 200, ], 'input' => [ 'shape' => 'SetTokenVaultCMKRequest', ], 'output' => [ 'shape' => 'SetTokenVaultCMKResponse', ], 'errors' => [ [ 'shape' => 'UnauthorizedException', ], [ 'shape' => 'ConcurrentModificationException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'SynchronizeGatewayTargets' => [ 'name' => 'SynchronizeGatewayTargets', 'http' => [ 'method' => 'PUT', 'requestUri' => '/gateways/{gatewayIdentifier}/synchronizeTargets', 'responseCode' => 202, ], 'input' => [ 'shape' => 'SynchronizeGatewayTargetsRequest', ], 'output' => [ 'shape' => 'SynchronizeGatewayTargetsResponse', ], 'errors' => [ [ 'shape' => 'ServiceQuotaExceededException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InternalServerException', ], ], 'idempotent' => true, ], 'TagResource' => [ 'name' => 'TagResource', 'http' => [ 'method' => 'POST', 'requestUri' => '/tags/{resourceArn}', 'responseCode' => 204, ], 'input' => [ 'shape' => 'TagResourceRequest', ], 'output' => [ 'shape' => 'TagResourceResponse', ], 'errors' => [ [ 'shape' => 'ServiceQuotaExceededException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InternalServerException', ], ], ], 'UntagResource' => [ 'name' => 'UntagResource', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/tags/{resourceArn}', 'responseCode' => 204, ], 'input' => [ 'shape' => 'UntagResourceRequest', ], 'output' => [ 'shape' => 'UntagResourceResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InternalServerException', ], ], 'idempotent' => true, ], 'UpdateAgentRuntime' => [ 'name' => 'UpdateAgentRuntime', 'http' => [ 'method' => 'PUT', 'requestUri' => '/runtimes/{agentRuntimeId}/', 'responseCode' => 202, ], 'input' => [ 'shape' => 'UpdateAgentRuntimeRequest', ], 'output' => [ 'shape' => 'UpdateAgentRuntimeResponse', ], 'errors' => [ [ 'shape' => 'ServiceQuotaExceededException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], 'idempotent' => true, ], 'UpdateAgentRuntimeEndpoint' => [ 'name' => 'UpdateAgentRuntimeEndpoint', 'http' => [ 'method' => 'PUT', 'requestUri' => '/runtimes/{agentRuntimeId}/runtime-endpoints/{endpointName}/', 'responseCode' => 202, ], 'input' => [ 'shape' => 'UpdateAgentRuntimeEndpointRequest', ], 'output' => [ 'shape' => 'UpdateAgentRuntimeEndpointResponse', ], 'errors' => [ [ 'shape' => 'ServiceQuotaExceededException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], 'idempotent' => true, ], 'UpdateApiKeyCredentialProvider' => [ 'name' => 'UpdateApiKeyCredentialProvider', 'http' => [ 'method' => 'POST', 'requestUri' => '/identities/UpdateApiKeyCredentialProvider', 'responseCode' => 200, ], 'input' => [ 'shape' => 'UpdateApiKeyCredentialProviderRequest', ], 'output' => [ 'shape' => 'UpdateApiKeyCredentialProviderResponse', ], 'errors' => [ [ 'shape' => 'ServiceQuotaExceededException', ], [ 'shape' => 'UnauthorizedException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'DecryptionFailure', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'EncryptionFailure', ], ], 'idempotent' => true, ], 'UpdateGateway' => [ 'name' => 'UpdateGateway', 'http' => [ 'method' => 'PUT', 'requestUri' => '/gateways/{gatewayIdentifier}/', 'responseCode' => 202, ], 'input' => [ 'shape' => 'UpdateGatewayRequest', ], 'output' => [ 'shape' => 'UpdateGatewayResponse', ], 'errors' => [ [ 'shape' => 'ServiceQuotaExceededException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InternalServerException', ], ], 'idempotent' => true, ], 'UpdateGatewayTarget' => [ 'name' => 'UpdateGatewayTarget', 'http' => [ 'method' => 'PUT', 'requestUri' => '/gateways/{gatewayIdentifier}/targets/{targetId}/', 'responseCode' => 202, ], 'input' => [ 'shape' => 'UpdateGatewayTargetRequest', ], 'output' => [ 'shape' => 'UpdateGatewayTargetResponse', ], 'errors' => [ [ 'shape' => 'ServiceQuotaExceededException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InternalServerException', ], ], 'idempotent' => true, ], 'UpdateMemory' => [ 'name' => 'UpdateMemory', 'http' => [ 'method' => 'PUT', 'requestUri' => '/memories/{memoryId}/update', 'responseCode' => 202, ], 'input' => [ 'shape' => 'UpdateMemoryInput', ], 'output' => [ 'shape' => 'UpdateMemoryOutput', ], 'errors' => [ [ 'shape' => 'ServiceException', ], [ 'shape' => 'ServiceQuotaExceededException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottledException', ], ], 'idempotent' => true, ], 'UpdateOauth2CredentialProvider' => [ 'name' => 'UpdateOauth2CredentialProvider', 'http' => [ 'method' => 'POST', 'requestUri' => '/identities/UpdateOauth2CredentialProvider', 'responseCode' => 200, ], 'input' => [ 'shape' => 'UpdateOauth2CredentialProviderRequest', ], 'output' => [ 'shape' => 'UpdateOauth2CredentialProviderResponse', ], 'errors' => [ [ 'shape' => 'ServiceQuotaExceededException', ], [ 'shape' => 'UnauthorizedException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'DecryptionFailure', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'EncryptionFailure', ], ], ], 'UpdateWorkloadIdentity' => [ 'name' => 'UpdateWorkloadIdentity', 'http' => [ 'method' => 'POST', 'requestUri' => '/identities/UpdateWorkloadIdentity', 'responseCode' => 200, ], 'input' => [ 'shape' => 'UpdateWorkloadIdentityRequest', ], 'output' => [ 'shape' => 'UpdateWorkloadIdentityResponse', ], 'errors' => [ [ 'shape' => 'UnauthorizedException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], 'idempotent' => true, ], ], 'shapes' => [ 'AccessDeniedException' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'NonBlankString', ], ], 'error' => [ 'httpStatusCode' => 403, 'senderFault' => true, ], 'exception' => true, ], 'AgentEndpointDescription' => [ 'type' => 'string', 'max' => 256, 'min' => 1, ], 'AgentManagedRuntimeType' => [ 'type' => 'string', 'enum' => [ 'PYTHON_3_10', 'PYTHON_3_11', 'PYTHON_3_12', 'PYTHON_3_13', ], ], 'AgentRuntime' => [ 'type' => 'structure', 'required' => [ 'agentRuntimeArn', 'agentRuntimeId', 'agentRuntimeVersion', 'agentRuntimeName', 'description', 'lastUpdatedAt', 'status', ], 'members' => [ 'agentRuntimeArn' => [ 'shape' => 'AgentRuntimeArn', ], 'agentRuntimeId' => [ 'shape' => 'AgentRuntimeId', ], 'agentRuntimeVersion' => [ 'shape' => 'AgentRuntimeVersion', ], 'agentRuntimeName' => [ 'shape' => 'AgentRuntimeName', ], 'description' => [ 'shape' => 'Description', ], 'lastUpdatedAt' => [ 'shape' => 'DateTimestamp', ], 'status' => [ 'shape' => 'AgentRuntimeStatus', ], ], ], 'AgentRuntimeArn' => [ 'type' => 'string', 'pattern' => 'arn:(-[^:]+)?:bedrock-agentcore:[a-z0-9-]+:[0-9]{12}:agent/[A-Fa-f0-9]{8}-[A-Fa-f0-9]{4}-[A-Fa-f0-9]{4}-[A-Fa-f0-9]{4}-[A-Fa-f0-9]{12}:([0-9]{0,4}[1-9][0-9]{0,4})', ], 'AgentRuntimeArtifact' => [ 'type' => 'structure', 'members' => [ 'containerConfiguration' => [ 'shape' => 'ContainerConfiguration', ], 'codeConfiguration' => [ 'shape' => 'CodeConfiguration', ], ], 'union' => true, ], 'AgentRuntimeEndpoint' => [ 'type' => 'structure', 'required' => [ 'name', 'agentRuntimeEndpointArn', 'agentRuntimeArn', 'status', 'id', 'createdAt', 'lastUpdatedAt', ], 'members' => [ 'name' => [ 'shape' => 'EndpointName', ], 'liveVersion' => [ 'shape' => 'AgentRuntimeVersion', ], 'targetVersion' => [ 'shape' => 'AgentRuntimeVersion', ], 'agentRuntimeEndpointArn' => [ 'shape' => 'AgentRuntimeEndpointArn', ], 'agentRuntimeArn' => [ 'shape' => 'AgentRuntimeArn', ], 'status' => [ 'shape' => 'AgentRuntimeEndpointStatus', ], 'id' => [ 'shape' => 'AgentRuntimeEndpointId', ], 'description' => [ 'shape' => 'AgentEndpointDescription', ], 'createdAt' => [ 'shape' => 'DateTimestamp', ], 'lastUpdatedAt' => [ 'shape' => 'DateTimestamp', ], ], ], 'AgentRuntimeEndpointArn' => [ 'type' => 'string', 'pattern' => 'arn:(-[^:]+)?:bedrock-agentcore:[a-z0-9-]+:[0-9]{12}:agentEndpoint/[A-Fa-f0-9]{8}-[A-Fa-f0-9]{4}-[A-Fa-f0-9]{4}-[A-Fa-f0-9]{4}-[A-Fa-f0-9]{12}', ], 'AgentRuntimeEndpointId' => [ 'type' => 'string', 'pattern' => '[a-zA-Z][a-zA-Z0-9_]{0,99}-[a-zA-Z0-9]{10}', ], 'AgentRuntimeEndpointStatus' => [ 'type' => 'string', 'enum' => [ 'CREATING', 'CREATE_FAILED', 'UPDATING', 'UPDATE_FAILED', 'READY', 'DELETING', ], ], 'AgentRuntimeEndpoints' => [ 'type' => 'list', 'member' => [ 'shape' => 'AgentRuntimeEndpoint', ], ], 'AgentRuntimeId' => [ 'type' => 'string', 'pattern' => '[a-zA-Z][a-zA-Z0-9_]{0,99}-[a-zA-Z0-9]{10}', ], 'AgentRuntimeName' => [ 'type' => 'string', 'pattern' => '[a-zA-Z][a-zA-Z0-9_]{0,47}', ], 'AgentRuntimeStatus' => [ 'type' => 'string', 'enum' => [ 'CREATING', 'CREATE_FAILED', 'UPDATING', 'UPDATE_FAILED', 'READY', 'DELETING', ], ], 'AgentRuntimeVersion' => [ 'type' => 'string', 'max' => 5, 'min' => 1, 'pattern' => '([1-9][0-9]{0,4})', ], 'AgentRuntimes' => [ 'type' => 'list', 'member' => [ 'shape' => 'AgentRuntime', ], ], 'AllowedAudience' => [ 'type' => 'string', ], 'AllowedAudienceList' => [ 'type' => 'list', 'member' => [ 'shape' => 'AllowedAudience', ], 'min' => 1, ], 'AllowedClient' => [ 'type' => 'string', ], 'AllowedClientsList' => [ 'type' => 'list', 'member' => [ 'shape' => 'AllowedClient', ], 'min' => 1, ], 'ApiKeyCredentialLocation' => [ 'type' => 'string', 'enum' => [ 'HEADER', 'QUERY_PARAMETER', ], ], 'ApiKeyCredentialParameterName' => [ 'type' => 'string', 'max' => 64, 'min' => 1, ], 'ApiKeyCredentialPrefix' => [ 'type' => 'string', 'max' => 64, 'min' => 1, ], 'ApiKeyCredentialProvider' => [ 'type' => 'structure', 'required' => [ 'providerArn', ], 'members' => [ 'providerArn' => [ 'shape' => 'ApiKeyCredentialProviderArn', ], 'credentialParameterName' => [ 'shape' => 'ApiKeyCredentialParameterName', ], 'credentialPrefix' => [ 'shape' => 'ApiKeyCredentialPrefix', ], 'credentialLocation' => [ 'shape' => 'ApiKeyCredentialLocation', ], ], ], 'ApiKeyCredentialProviderArn' => [ 'type' => 'string', 'pattern' => 'arn:([^:]*):([^:]*):([^:]*):([0-9]{12})?:(.+)', ], 'ApiKeyCredentialProviderArnType' => [ 'type' => 'string', 'pattern' => 'arn:(aws|aws-us-gov):acps:[A-Za-z0-9-]{1,64}:[0-9]{12}:token-vault/[a-zA-Z0-9-.]+/apikeycredentialprovider/[a-zA-Z0-9-.]+', ], 'ApiKeyCredentialProviderItem' => [ 'type' => 'structure', 'required' => [ 'name', 'credentialProviderArn', 'createdTime', 'lastUpdatedTime', ], 'members' => [ 'name' => [ 'shape' => 'CredentialProviderName', ], 'credentialProviderArn' => [ 'shape' => 'ApiKeyCredentialProviderArnType', ], 'createdTime' => [ 'shape' => 'Timestamp', ], 'lastUpdatedTime' => [ 'shape' => 'Timestamp', ], ], ], 'ApiKeyCredentialProviders' => [ 'type' => 'list', 'member' => [ 'shape' => 'ApiKeyCredentialProviderItem', ], ], 'ApiKeyType' => [ 'type' => 'string', 'max' => 65536, 'min' => 1, 'sensitive' => true, ], 'ApiSchemaConfiguration' => [ 'type' => 'structure', 'members' => [ 's3' => [ 'shape' => 'S3Configuration', ], 'inlinePayload' => [ 'shape' => 'InlinePayload', ], ], 'union' => true, ], 'Arn' => [ 'type' => 'string', 'pattern' => 'arn:[a-z0-9-\\.]{1,63}:[a-z0-9-\\.]{0,63}:[a-z0-9-\\.]{0,63}:[a-z0-9-\\.]{0,63}:[^/].{0,1023}', ], 'AtlassianOauth2ProviderConfigInput' => [ 'type' => 'structure', 'required' => [ 'clientId', 'clientSecret', ], 'members' => [ 'clientId' => [ 'shape' => 'ClientIdType', ], 'clientSecret' => [ 'shape' => 'ClientSecretType', ], ], ], 'AtlassianOauth2ProviderConfigOutput' => [ 'type' => 'structure', 'required' => [ 'oauthDiscovery', ], 'members' => [ 'oauthDiscovery' => [ 'shape' => 'Oauth2Discovery', ], 'clientId' => [ 'shape' => 'ClientIdType', ], ], ], 'AuthorizationEndpointType' => [ 'type' => 'string', ], 'AuthorizerConfiguration' => [ 'type' => 'structure', 'members' => [ 'customJWTAuthorizer' => [ 'shape' => 'CustomJWTAuthorizerConfiguration', ], ], 'union' => true, ], 'AuthorizerType' => [ 'type' => 'string', 'enum' => [ 'CUSTOM_JWT', 'AWS_IAM', 'NONE', ], ], 'AwsAccountId' => [ 'type' => 'string', 'pattern' => '[0-9]{12}', ], 'Boolean' => [ 'type' => 'boolean', 'box' => true, ], 'BrowserArn' => [ 'type' => 'string', 'pattern' => 'arn:(-[^:]+)?:bedrock-agentcore:[a-z0-9-]+:(aws|[0-9]{12}):browser(-custom)?/(aws\\.browser\\.v1|[a-zA-Z][a-zA-Z0-9_]{0,47}-[a-zA-Z0-9]{10})', ], 'BrowserId' => [ 'type' => 'string', 'pattern' => '(aws\\.browser\\.v1|[a-zA-Z][a-zA-Z0-9_]{0,47}-[a-zA-Z0-9]{10})', ], 'BrowserNetworkConfiguration' => [ 'type' => 'structure', 'required' => [ 'networkMode', ], 'members' => [ 'networkMode' => [ 'shape' => 'BrowserNetworkMode', ], 'vpcConfig' => [ 'shape' => 'VpcConfig', ], ], ], 'BrowserNetworkMode' => [ 'type' => 'string', 'enum' => [ 'PUBLIC', 'VPC', ], ], 'BrowserSigningConfigInput' => [ 'type' => 'structure', 'required' => [ 'enabled', ], 'members' => [ 'enabled' => [ 'shape' => 'Boolean', ], ], ], 'BrowserSigningConfigOutput' => [ 'type' => 'structure', 'required' => [ 'enabled', ], 'members' => [ 'enabled' => [ 'shape' => 'Boolean', ], ], ], 'BrowserStatus' => [ 'type' => 'string', 'enum' => [ 'CREATING', 'CREATE_FAILED', 'READY', 'DELETING', 'DELETE_FAILED', 'DELETED', ], ], 'BrowserSummaries' => [ 'type' => 'list', 'member' => [ 'shape' => 'BrowserSummary', ], ], 'BrowserSummary' => [ 'type' => 'structure', 'required' => [ 'browserId', 'browserArn', 'status', 'createdAt', ], 'members' => [ 'browserId' => [ 'shape' => 'BrowserId', ], 'browserArn' => [ 'shape' => 'BrowserArn', ], 'name' => [ 'shape' => 'SandboxName', ], 'description' => [ 'shape' => 'Description', ], 'status' => [ 'shape' => 'BrowserStatus', ], 'createdAt' => [ 'shape' => 'DateTimestamp', ], 'lastUpdatedAt' => [ 'shape' => 'DateTimestamp', ], ], ], 'ClientIdType' => [ 'type' => 'string', 'max' => 256, 'min' => 1, ], 'ClientSecretType' => [ 'type' => 'string', 'max' => 2048, 'min' => 1, 'sensitive' => true, ], 'ClientToken' => [ 'type' => 'string', 'max' => 256, 'min' => 33, 'pattern' => '[a-zA-Z0-9](-*[a-zA-Z0-9]){0,256}', ], 'Code' => [ 'type' => 'structure', 'members' => [ 's3' => [ 'shape' => 'S3Location', ], ], 'union' => true, ], 'CodeConfiguration' => [ 'type' => 'structure', 'required' => [ 'code', 'runtime', 'entryPoint', ], 'members' => [ 'code' => [ 'shape' => 'Code', ], 'runtime' => [ 'shape' => 'AgentManagedRuntimeType', ], 'entryPoint' => [ 'shape' => 'CodeConfigurationEntryPointList', ], ], ], 'CodeConfigurationEntryPointList' => [ 'type' => 'list', 'member' => [ 'shape' => 'entryPoint', ], 'max' => 2, 'min' => 1, ], 'CodeInterpreterArn' => [ 'type' => 'string', 'pattern' => 'arn:(-[^:]+)?:bedrock-agentcore:[a-z0-9-]+:(aws|[0-9]{12}):code-interpreter(-custom)?/(aws\\.codeinterpreter\\.v1|[a-zA-Z][a-zA-Z0-9_]{0,47}-[a-zA-Z0-9]{10})', ], 'CodeInterpreterId' => [ 'type' => 'string', 'pattern' => '(aws\\.codeinterpreter\\.v1|[a-zA-Z][a-zA-Z0-9_]{0,47}-[a-zA-Z0-9]{10})', ], 'CodeInterpreterNetworkConfiguration' => [ 'type' => 'structure', 'required' => [ 'networkMode', ], 'members' => [ 'networkMode' => [ 'shape' => 'CodeInterpreterNetworkMode', ], 'vpcConfig' => [ 'shape' => 'VpcConfig', ], ], ], 'CodeInterpreterNetworkMode' => [ 'type' => 'string', 'enum' => [ 'PUBLIC', 'SANDBOX', 'VPC', ], ], 'CodeInterpreterStatus' => [ 'type' => 'string', 'enum' => [ 'CREATING', 'CREATE_FAILED', 'READY', 'DELETING', 'DELETE_FAILED', 'DELETED', ], ], 'CodeInterpreterSummaries' => [ 'type' => 'list', 'member' => [ 'shape' => 'CodeInterpreterSummary', ], ], 'CodeInterpreterSummary' => [ 'type' => 'structure', 'required' => [ 'codeInterpreterId', 'codeInterpreterArn', 'status', 'createdAt', ], 'members' => [ 'codeInterpreterId' => [ 'shape' => 'CodeInterpreterId', ], 'codeInterpreterArn' => [ 'shape' => 'CodeInterpreterArn', ], 'name' => [ 'shape' => 'SandboxName', ], 'description' => [ 'shape' => 'Description', ], 'status' => [ 'shape' => 'CodeInterpreterStatus', ], 'createdAt' => [ 'shape' => 'DateTimestamp', ], 'lastUpdatedAt' => [ 'shape' => 'DateTimestamp', ], ], ], 'ConcurrentModificationException' => [ 'type' => 'structure', 'required' => [ 'message', ], 'members' => [ 'message' => [ 'shape' => 'String', ], ], 'error' => [ 'httpStatusCode' => 409, 'senderFault' => true, ], 'exception' => true, ], 'ConflictException' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'NonBlankString', ], ], 'error' => [ 'httpStatusCode' => 409, 'senderFault' => true, ], 'exception' => true, ], 'ConsolidationConfiguration' => [ 'type' => 'structure', 'members' => [ 'customConsolidationConfiguration' => [ 'shape' => 'CustomConsolidationConfiguration', ], ], 'union' => true, ], 'ContainerConfiguration' => [ 'type' => 'structure', 'required' => [ 'containerUri', ], 'members' => [ 'containerUri' => [ 'shape' => 'RuntimeContainerUri', ], ], ], 'CreateAgentRuntimeEndpointRequest' => [ 'type' => 'structure', 'required' => [ 'agentRuntimeId', 'name', ], 'members' => [ 'agentRuntimeId' => [ 'shape' => 'AgentRuntimeId', 'location' => 'uri', 'locationName' => 'agentRuntimeId', ], 'name' => [ 'shape' => 'EndpointName', ], 'agentRuntimeVersion' => [ 'shape' => 'AgentRuntimeVersion', ], 'description' => [ 'shape' => 'AgentEndpointDescription', ], 'clientToken' => [ 'shape' => 'ClientToken', 'idempotencyToken' => true, ], 'tags' => [ 'shape' => 'TagsMap', ], ], ], 'CreateAgentRuntimeEndpointResponse' => [ 'type' => 'structure', 'required' => [ 'targetVersion', 'agentRuntimeEndpointArn', 'agentRuntimeArn', 'status', 'createdAt', ], 'members' => [ 'targetVersion' => [ 'shape' => 'AgentRuntimeVersion', ], 'agentRuntimeEndpointArn' => [ 'shape' => 'AgentRuntimeEndpointArn', ], 'agentRuntimeArn' => [ 'shape' => 'AgentRuntimeArn', ], 'agentRuntimeId' => [ 'shape' => 'AgentRuntimeId', ], 'endpointName' => [ 'shape' => 'EndpointName', ], 'status' => [ 'shape' => 'AgentRuntimeEndpointStatus', ], 'createdAt' => [ 'shape' => 'DateTimestamp', ], ], ], 'CreateAgentRuntimeRequest' => [ 'type' => 'structure', 'required' => [ 'agentRuntimeName', 'agentRuntimeArtifact', 'roleArn', 'networkConfiguration', ], 'members' => [ 'agentRuntimeName' => [ 'shape' => 'AgentRuntimeName', ], 'agentRuntimeArtifact' => [ 'shape' => 'AgentRuntimeArtifact', ], 'roleArn' => [ 'shape' => 'RoleArn', ], 'networkConfiguration' => [ 'shape' => 'NetworkConfiguration', ], 'clientToken' => [ 'shape' => 'ClientToken', 'idempotencyToken' => true, ], 'description' => [ 'shape' => 'Description', ], 'authorizerConfiguration' => [ 'shape' => 'AuthorizerConfiguration', ], 'requestHeaderConfiguration' => [ 'shape' => 'RequestHeaderConfiguration', ], 'protocolConfiguration' => [ 'shape' => 'ProtocolConfiguration', ], 'lifecycleConfiguration' => [ 'shape' => 'LifecycleConfiguration', ], 'environmentVariables' => [ 'shape' => 'EnvironmentVariablesMap', ], 'tags' => [ 'shape' => 'TagsMap', ], ], ], 'CreateAgentRuntimeResponse' => [ 'type' => 'structure', 'required' => [ 'agentRuntimeArn', 'agentRuntimeId', 'agentRuntimeVersion', 'createdAt', 'status', ], 'members' => [ 'agentRuntimeArn' => [ 'shape' => 'AgentRuntimeArn', ], 'workloadIdentityDetails' => [ 'shape' => 'WorkloadIdentityDetails', ], 'agentRuntimeId' => [ 'shape' => 'AgentRuntimeId', ], 'agentRuntimeVersion' => [ 'shape' => 'AgentRuntimeVersion', ], 'createdAt' => [ 'shape' => 'DateTimestamp', ], 'status' => [ 'shape' => 'AgentRuntimeStatus', ], ], ], 'CreateApiKeyCredentialProviderRequest' => [ 'type' => 'structure', 'required' => [ 'name', 'apiKey', ], 'members' => [ 'name' => [ 'shape' => 'CredentialProviderName', ], 'apiKey' => [ 'shape' => 'ApiKeyType', ], 'tags' => [ 'shape' => 'TagsMap', ], ], ], 'CreateApiKeyCredentialProviderResponse' => [ 'type' => 'structure', 'required' => [ 'apiKeySecretArn', 'name', 'credentialProviderArn', ], 'members' => [ 'apiKeySecretArn' => [ 'shape' => 'Secret', ], 'name' => [ 'shape' => 'CredentialProviderName', ], 'credentialProviderArn' => [ 'shape' => 'ApiKeyCredentialProviderArnType', ], ], ], 'CreateBrowserRequest' => [ 'type' => 'structure', 'required' => [ 'name', 'networkConfiguration', ], 'members' => [ 'name' => [ 'shape' => 'SandboxName', ], 'description' => [ 'shape' => 'Description', ], 'executionRoleArn' => [ 'shape' => 'RoleArn', ], 'networkConfiguration' => [ 'shape' => 'BrowserNetworkConfiguration', ], 'recording' => [ 'shape' => 'RecordingConfig', ], 'browserSigning' => [ 'shape' => 'BrowserSigningConfigInput', ], 'clientToken' => [ 'shape' => 'ClientToken', 'idempotencyToken' => true, ], 'tags' => [ 'shape' => 'TagsMap', ], ], ], 'CreateBrowserResponse' => [ 'type' => 'structure', 'required' => [ 'browserId', 'browserArn', 'createdAt', 'status', ], 'members' => [ 'browserId' => [ 'shape' => 'BrowserId', ], 'browserArn' => [ 'shape' => 'BrowserArn', ], 'createdAt' => [ 'shape' => 'DateTimestamp', ], 'status' => [ 'shape' => 'BrowserStatus', ], ], ], 'CreateCodeInterpreterRequest' => [ 'type' => 'structure', 'required' => [ 'name', 'networkConfiguration', ], 'members' => [ 'name' => [ 'shape' => 'SandboxName', ], 'description' => [ 'shape' => 'Description', ], 'executionRoleArn' => [ 'shape' => 'RoleArn', ], 'networkConfiguration' => [ 'shape' => 'CodeInterpreterNetworkConfiguration', ], 'clientToken' => [ 'shape' => 'ClientToken', 'idempotencyToken' => true, ], 'tags' => [ 'shape' => 'TagsMap', ], ], ], 'CreateCodeInterpreterResponse' => [ 'type' => 'structure', 'required' => [ 'codeInterpreterId', 'codeInterpreterArn', 'createdAt', 'status', ], 'members' => [ 'codeInterpreterId' => [ 'shape' => 'CodeInterpreterId', ], 'codeInterpreterArn' => [ 'shape' => 'CodeInterpreterArn', ], 'createdAt' => [ 'shape' => 'DateTimestamp', ], 'status' => [ 'shape' => 'CodeInterpreterStatus', ], ], ], 'CreateGatewayRequest' => [ 'type' => 'structure', 'required' => [ 'name', 'roleArn', 'protocolType', 'authorizerType', ], 'members' => [ 'name' => [ 'shape' => 'GatewayName', ], 'description' => [ 'shape' => 'GatewayDescription', ], 'clientToken' => [ 'shape' => 'ClientToken', 'idempotencyToken' => true, ], 'roleArn' => [ 'shape' => 'RoleArn', ], 'protocolType' => [ 'shape' => 'GatewayProtocolType', ], 'protocolConfiguration' => [ 'shape' => 'GatewayProtocolConfiguration', ], 'authorizerType' => [ 'shape' => 'AuthorizerType', ], 'authorizerConfiguration' => [ 'shape' => 'AuthorizerConfiguration', ], 'kmsKeyArn' => [ 'shape' => 'KmsKeyArn', ], 'interceptorConfigurations' => [ 'shape' => 'GatewayInterceptorConfigurations', ], 'exceptionLevel' => [ 'shape' => 'ExceptionLevel', ], 'tags' => [ 'shape' => 'TagsMap', ], ], ], 'CreateGatewayResponse' => [ 'type' => 'structure', 'required' => [ 'gatewayArn', 'gatewayId', 'createdAt', 'updatedAt', 'status', 'name', 'protocolType', 'authorizerType', ], 'members' => [ 'gatewayArn' => [ 'shape' => 'GatewayArn', ], 'gatewayId' => [ 'shape' => 'GatewayId', ], 'gatewayUrl' => [ 'shape' => 'GatewayUrl', ], 'createdAt' => [ 'shape' => 'DateTimestamp', ], 'updatedAt' => [ 'shape' => 'DateTimestamp', ], 'status' => [ 'shape' => 'GatewayStatus', ], 'statusReasons' => [ 'shape' => 'StatusReasons', ], 'name' => [ 'shape' => 'GatewayName', ], 'description' => [ 'shape' => 'GatewayDescription', ], 'roleArn' => [ 'shape' => 'RoleArn', ], 'protocolType' => [ 'shape' => 'GatewayProtocolType', ], 'protocolConfiguration' => [ 'shape' => 'GatewayProtocolConfiguration', ], 'authorizerType' => [ 'shape' => 'AuthorizerType', ], 'authorizerConfiguration' => [ 'shape' => 'AuthorizerConfiguration', ], 'kmsKeyArn' => [ 'shape' => 'KmsKeyArn', ], 'interceptorConfigurations' => [ 'shape' => 'GatewayInterceptorConfigurations', ], 'workloadIdentityDetails' => [ 'shape' => 'WorkloadIdentityDetails', ], 'exceptionLevel' => [ 'shape' => 'ExceptionLevel', ], ], ], 'CreateGatewayTargetRequest' => [ 'type' => 'structure', 'required' => [ 'gatewayIdentifier', 'name', 'targetConfiguration', ], 'members' => [ 'gatewayIdentifier' => [ 'shape' => 'GatewayIdentifier', 'location' => 'uri', 'locationName' => 'gatewayIdentifier', ], 'name' => [ 'shape' => 'TargetName', ], 'description' => [ 'shape' => 'TargetDescription', ], 'clientToken' => [ 'shape' => 'ClientToken', 'idempotencyToken' => true, ], 'targetConfiguration' => [ 'shape' => 'TargetConfiguration', ], 'credentialProviderConfigurations' => [ 'shape' => 'CredentialProviderConfigurations', ], ], ], 'CreateGatewayTargetResponse' => [ 'type' => 'structure', 'required' => [ 'gatewayArn', 'targetId', 'createdAt', 'updatedAt', 'status', 'name', 'targetConfiguration', 'credentialProviderConfigurations', ], 'members' => [ 'gatewayArn' => [ 'shape' => 'GatewayArn', ], 'targetId' => [ 'shape' => 'TargetId', ], 'createdAt' => [ 'shape' => 'DateTimestamp', ], 'updatedAt' => [ 'shape' => 'DateTimestamp', ], 'status' => [ 'shape' => 'TargetStatus', ], 'statusReasons' => [ 'shape' => 'StatusReasons', ], 'name' => [ 'shape' => 'TargetName', ], 'description' => [ 'shape' => 'TargetDescription', ], 'targetConfiguration' => [ 'shape' => 'TargetConfiguration', ], 'credentialProviderConfigurations' => [ 'shape' => 'CredentialProviderConfigurations', ], 'lastSynchronizedAt' => [ 'shape' => 'DateTimestamp', ], ], ], 'CreateMemoryInput' => [ 'type' => 'structure', 'required' => [ 'name', 'eventExpiryDuration', ], 'members' => [ 'clientToken' => [ 'shape' => 'CreateMemoryInputClientTokenString', 'idempotencyToken' => true, ], 'name' => [ 'shape' => 'Name', ], 'description' => [ 'shape' => 'Description', ], 'encryptionKeyArn' => [ 'shape' => 'Arn', ], 'memoryExecutionRoleArn' => [ 'shape' => 'Arn', ], 'eventExpiryDuration' => [ 'shape' => 'CreateMemoryInputEventExpiryDurationInteger', ], 'memoryStrategies' => [ 'shape' => 'MemoryStrategyInputList', ], 'tags' => [ 'shape' => 'TagsMap', ], ], ], 'CreateMemoryInputClientTokenString' => [ 'type' => 'string', 'max' => 500, 'min' => 0, ], 'CreateMemoryInputEventExpiryDurationInteger' => [ 'type' => 'integer', 'box' => true, 'max' => 365, 'min' => 7, ], 'CreateMemoryOutput' => [ 'type' => 'structure', 'members' => [ 'memory' => [ 'shape' => 'Memory', ], ], ], 'CreateOauth2CredentialProviderRequest' => [ 'type' => 'structure', 'required' => [ 'name', 'credentialProviderVendor', 'oauth2ProviderConfigInput', ], 'members' => [ 'name' => [ 'shape' => 'CredentialProviderName', ], 'credentialProviderVendor' => [ 'shape' => 'CredentialProviderVendorType', ], 'oauth2ProviderConfigInput' => [ 'shape' => 'Oauth2ProviderConfigInput', ], 'tags' => [ 'shape' => 'TagsMap', ], ], ], 'CreateOauth2CredentialProviderResponse' => [ 'type' => 'structure', 'required' => [ 'clientSecretArn', 'name', 'credentialProviderArn', ], 'members' => [ 'clientSecretArn' => [ 'shape' => 'Secret', ], 'name' => [ 'shape' => 'CredentialProviderName', ], 'credentialProviderArn' => [ 'shape' => 'CredentialProviderArnType', ], 'callbackUrl' => [ 'shape' => 'String', ], 'oauth2ProviderConfigOutput' => [ 'shape' => 'Oauth2ProviderConfigOutput', ], ], ], 'CreateWorkloadIdentityRequest' => [ 'type' => 'structure', 'required' => [ 'name', ], 'members' => [ 'name' => [ 'shape' => 'WorkloadIdentityNameType', ], 'allowedResourceOauth2ReturnUrls' => [ 'shape' => 'ResourceOauth2ReturnUrlListType', ], 'tags' => [ 'shape' => 'TagsMap', ], ], ], 'CreateWorkloadIdentityResponse' => [ 'type' => 'structure', 'required' => [ 'name', 'workloadIdentityArn', ], 'members' => [ 'name' => [ 'shape' => 'WorkloadIdentityNameType', ], 'workloadIdentityArn' => [ 'shape' => 'WorkloadIdentityArnType', ], 'allowedResourceOauth2ReturnUrls' => [ 'shape' => 'ResourceOauth2ReturnUrlListType', ], ], ], 'CredentialProvider' => [ 'type' => 'structure', 'members' => [ 'oauthCredentialProvider' => [ 'shape' => 'OAuthCredentialProvider', ], 'apiKeyCredentialProvider' => [ 'shape' => 'ApiKeyCredentialProvider', ], ], 'union' => true, ], 'CredentialProviderArnType' => [ 'type' => 'string', 'pattern' => 'arn:(aws|aws-us-gov):acps:[A-Za-z0-9-]{1,64}:[0-9]{12}:token-vault/[a-zA-Z0-9-.]+/oauth2credentialprovider/[a-zA-Z0-9-.]+', ], 'CredentialProviderConfiguration' => [ 'type' => 'structure', 'required' => [ 'credentialProviderType', ], 'members' => [ 'credentialProviderType' => [ 'shape' => 'CredentialProviderType', ], 'credentialProvider' => [ 'shape' => 'CredentialProvider', ], ], ], 'CredentialProviderConfigurations' => [ 'type' => 'list', 'member' => [ 'shape' => 'CredentialProviderConfiguration', ], 'max' => 1, 'min' => 1, ], 'CredentialProviderName' => [ 'type' => 'string', 'max' => 128, 'min' => 1, 'pattern' => '[a-zA-Z0-9\\-_]+', ], 'CredentialProviderType' => [ 'type' => 'string', 'enum' => [ 'GATEWAY_IAM_ROLE', 'OAUTH', 'API_KEY', ], ], 'CredentialProviderVendorType' => [ 'type' => 'string', 'enum' => [ 'GoogleOauth2', 'GithubOauth2', 'SlackOauth2', 'SalesforceOauth2', 'MicrosoftOauth2', 'CustomOauth2', 'AtlassianOauth2', 'LinkedinOauth2', 'XOauth2', 'OktaOauth2', 'OneLoginOauth2', 'PingOneOauth2', 'FacebookOauth2', 'YandexOauth2', 'RedditOauth2', 'ZoomOauth2', 'TwitchOauth2', 'SpotifyOauth2', 'DropboxOauth2', 'NotionOauth2', 'HubspotOauth2', 'CyberArkOauth2', 'FusionAuthOauth2', 'Auth0Oauth2', 'CognitoOauth2', ], ], 'CustomConfigurationInput' => [ 'type' => 'structure', 'members' => [ 'semanticOverride' => [ 'shape' => 'SemanticOverrideConfigurationInput', ], 'summaryOverride' => [ 'shape' => 'SummaryOverrideConfigurationInput', ], 'userPreferenceOverride' => [ 'shape' => 'UserPreferenceOverrideConfigurationInput', ], 'selfManagedConfiguration' => [ 'shape' => 'SelfManagedConfigurationInput', ], ], 'union' => true, ], 'CustomConsolidationConfiguration' => [ 'type' => 'structure', 'members' => [ 'semanticConsolidationOverride' => [ 'shape' => 'SemanticConsolidationOverride', ], 'summaryConsolidationOverride' => [ 'shape' => 'SummaryConsolidationOverride', ], 'userPreferenceConsolidationOverride' => [ 'shape' => 'UserPreferenceConsolidationOverride', ], ], 'union' => true, ], 'CustomConsolidationConfigurationInput' => [ 'type' => 'structure', 'members' => [ 'semanticConsolidationOverride' => [ 'shape' => 'SemanticOverrideConsolidationConfigurationInput', ], 'summaryConsolidationOverride' => [ 'shape' => 'SummaryOverrideConsolidationConfigurationInput', ], 'userPreferenceConsolidationOverride' => [ 'shape' => 'UserPreferenceOverrideConsolidationConfigurationInput', ], ], 'union' => true, ], 'CustomExtractionConfiguration' => [ 'type' => 'structure', 'members' => [ 'semanticExtractionOverride' => [ 'shape' => 'SemanticExtractionOverride', ], 'userPreferenceExtractionOverride' => [ 'shape' => 'UserPreferenceExtractionOverride', ], ], 'union' => true, ], 'CustomExtractionConfigurationInput' => [ 'type' => 'structure', 'members' => [ 'semanticExtractionOverride' => [ 'shape' => 'SemanticOverrideExtractionConfigurationInput', ], 'userPreferenceExtractionOverride' => [ 'shape' => 'UserPreferenceOverrideExtractionConfigurationInput', ], ], 'union' => true, ], 'CustomJWTAuthorizerConfiguration' => [ 'type' => 'structure', 'required' => [ 'discoveryUrl', ], 'members' => [ 'discoveryUrl' => [ 'shape' => 'DiscoveryUrl', ], 'allowedAudience' => [ 'shape' => 'AllowedAudienceList', ], 'allowedClients' => [ 'shape' => 'AllowedClientsList', ], ], ], 'CustomMemoryStrategyInput' => [ 'type' => 'structure', 'required' => [ 'name', ], 'members' => [ 'name' => [ 'shape' => 'Name', ], 'description' => [ 'shape' => 'Description', ], 'namespaces' => [ 'shape' => 'NamespacesList', ], 'configuration' => [ 'shape' => 'CustomConfigurationInput', ], ], ], 'CustomOauth2ProviderConfigInput' => [ 'type' => 'structure', 'required' => [ 'oauthDiscovery', 'clientId', 'clientSecret', ], 'members' => [ 'oauthDiscovery' => [ 'shape' => 'Oauth2Discovery', ], 'clientId' => [ 'shape' => 'ClientIdType', ], 'clientSecret' => [ 'shape' => 'ClientSecretType', ], ], ], 'CustomOauth2ProviderConfigOutput' => [ 'type' => 'structure', 'required' => [ 'oauthDiscovery', ], 'members' => [ 'oauthDiscovery' => [ 'shape' => 'Oauth2Discovery', ], 'clientId' => [ 'shape' => 'ClientIdType', ], ], ], 'DateTimestamp' => [ 'type' => 'timestamp', 'timestampFormat' => 'iso8601', ], 'DecryptionFailure' => [ 'type' => 'structure', 'required' => [ 'message', ], 'members' => [ 'message' => [ 'shape' => 'String', ], ], 'error' => [ 'httpStatusCode' => 400, 'senderFault' => true, ], 'exception' => true, ], 'DeleteAgentRuntimeEndpointRequest' => [ 'type' => 'structure', 'required' => [ 'agentRuntimeId', 'endpointName', ], 'members' => [ 'agentRuntimeId' => [ 'shape' => 'AgentRuntimeId', 'location' => 'uri', 'locationName' => 'agentRuntimeId', ], 'endpointName' => [ 'shape' => 'EndpointName', 'location' => 'uri', 'locationName' => 'endpointName', ], 'clientToken' => [ 'shape' => 'ClientToken', 'idempotencyToken' => true, 'location' => 'querystring', 'locationName' => 'clientToken', ], ], ], 'DeleteAgentRuntimeEndpointResponse' => [ 'type' => 'structure', 'required' => [ 'status', ], 'members' => [ 'status' => [ 'shape' => 'AgentRuntimeEndpointStatus', ], 'agentRuntimeId' => [ 'shape' => 'AgentRuntimeId', ], 'endpointName' => [ 'shape' => 'EndpointName', ], ], ], 'DeleteAgentRuntimeRequest' => [ 'type' => 'structure', 'required' => [ 'agentRuntimeId', ], 'members' => [ 'agentRuntimeId' => [ 'shape' => 'AgentRuntimeId', 'location' => 'uri', 'locationName' => 'agentRuntimeId', ], 'clientToken' => [ 'shape' => 'ClientToken', 'idempotencyToken' => true, 'location' => 'querystring', 'locationName' => 'clientToken', ], ], ], 'DeleteAgentRuntimeResponse' => [ 'type' => 'structure', 'required' => [ 'status', ], 'members' => [ 'status' => [ 'shape' => 'AgentRuntimeStatus', ], 'agentRuntimeId' => [ 'shape' => 'AgentRuntimeId', ], ], ], 'DeleteApiKeyCredentialProviderRequest' => [ 'type' => 'structure', 'required' => [ 'name', ], 'members' => [ 'name' => [ 'shape' => 'CredentialProviderName', ], ], ], 'DeleteApiKeyCredentialProviderResponse' => [ 'type' => 'structure', 'members' => [], ], 'DeleteBrowserRequest' => [ 'type' => 'structure', 'required' => [ 'browserId', ], 'members' => [ 'browserId' => [ 'shape' => 'BrowserId', 'location' => 'uri', 'locationName' => 'browserId', ], 'clientToken' => [ 'shape' => 'ClientToken', 'idempotencyToken' => true, 'location' => 'querystring', 'locationName' => 'clientToken', ], ], ], 'DeleteBrowserResponse' => [ 'type' => 'structure', 'required' => [ 'browserId', 'status', 'lastUpdatedAt', ], 'members' => [ 'browserId' => [ 'shape' => 'BrowserId', ], 'status' => [ 'shape' => 'BrowserStatus', ], 'lastUpdatedAt' => [ 'shape' => 'DateTimestamp', ], ], ], 'DeleteCodeInterpreterRequest' => [ 'type' => 'structure', 'required' => [ 'codeInterpreterId', ], 'members' => [ 'codeInterpreterId' => [ 'shape' => 'CodeInterpreterId', 'location' => 'uri', 'locationName' => 'codeInterpreterId', ], 'clientToken' => [ 'shape' => 'ClientToken', 'idempotencyToken' => true, 'location' => 'querystring', 'locationName' => 'clientToken', ], ], ], 'DeleteCodeInterpreterResponse' => [ 'type' => 'structure', 'required' => [ 'codeInterpreterId', 'status', 'lastUpdatedAt', ], 'members' => [ 'codeInterpreterId' => [ 'shape' => 'CodeInterpreterId', ], 'status' => [ 'shape' => 'CodeInterpreterStatus', ], 'lastUpdatedAt' => [ 'shape' => 'DateTimestamp', ], ], ], 'DeleteGatewayRequest' => [ 'type' => 'structure', 'required' => [ 'gatewayIdentifier', ], 'members' => [ 'gatewayIdentifier' => [ 'shape' => 'GatewayIdentifier', 'location' => 'uri', 'locationName' => 'gatewayIdentifier', ], ], ], 'DeleteGatewayResponse' => [ 'type' => 'structure', 'required' => [ 'gatewayId', 'status', ], 'members' => [ 'gatewayId' => [ 'shape' => 'GatewayId', ], 'status' => [ 'shape' => 'GatewayStatus', ], 'statusReasons' => [ 'shape' => 'StatusReasons', ], ], ], 'DeleteGatewayTargetRequest' => [ 'type' => 'structure', 'required' => [ 'gatewayIdentifier', 'targetId', ], 'members' => [ 'gatewayIdentifier' => [ 'shape' => 'GatewayIdentifier', 'location' => 'uri', 'locationName' => 'gatewayIdentifier', ], 'targetId' => [ 'shape' => 'TargetId', 'location' => 'uri', 'locationName' => 'targetId', ], ], ], 'DeleteGatewayTargetResponse' => [ 'type' => 'structure', 'required' => [ 'gatewayArn', 'targetId', 'status', ], 'members' => [ 'gatewayArn' => [ 'shape' => 'GatewayArn', ], 'targetId' => [ 'shape' => 'TargetId', ], 'status' => [ 'shape' => 'TargetStatus', ], 'statusReasons' => [ 'shape' => 'StatusReasons', ], ], ], 'DeleteMemoryInput' => [ 'type' => 'structure', 'required' => [ 'memoryId', ], 'members' => [ 'clientToken' => [ 'shape' => 'DeleteMemoryInputClientTokenString', 'idempotencyToken' => true, 'location' => 'querystring', 'locationName' => 'clientToken', ], 'memoryId' => [ 'shape' => 'MemoryId', 'location' => 'uri', 'locationName' => 'memoryId', ], ], ], 'DeleteMemoryInputClientTokenString' => [ 'type' => 'string', 'max' => 500, 'min' => 0, ], 'DeleteMemoryOutput' => [ 'type' => 'structure', 'required' => [ 'memoryId', ], 'members' => [ 'memoryId' => [ 'shape' => 'MemoryId', ], 'status' => [ 'shape' => 'MemoryStatus', ], ], ], 'DeleteMemoryStrategiesList' => [ 'type' => 'list', 'member' => [ 'shape' => 'DeleteMemoryStrategyInput', ], ], 'DeleteMemoryStrategyInput' => [ 'type' => 'structure', 'required' => [ 'memoryStrategyId', ], 'members' => [ 'memoryStrategyId' => [ 'shape' => 'String', ], ], ], 'DeleteOauth2CredentialProviderRequest' => [ 'type' => 'structure', 'required' => [ 'name', ], 'members' => [ 'name' => [ 'shape' => 'CredentialProviderName', ], ], ], 'DeleteOauth2CredentialProviderResponse' => [ 'type' => 'structure', 'members' => [], ], 'DeleteWorkloadIdentityRequest' => [ 'type' => 'structure', 'required' => [ 'name', ], 'members' => [ 'name' => [ 'shape' => 'WorkloadIdentityNameType', ], ], ], 'DeleteWorkloadIdentityResponse' => [ 'type' => 'structure', 'members' => [], ], 'Description' => [ 'type' => 'string', 'max' => 4096, 'min' => 1, 'sensitive' => true, ], 'DiscoveryUrl' => [ 'type' => 'string', 'pattern' => '.+/\\.well-known/openid-configuration', ], 'DiscoveryUrlType' => [ 'type' => 'string', 'pattern' => '.+/\\.well-known/openid-configuration', ], 'EncryptionFailure' => [ 'type' => 'structure', 'required' => [ 'message', ], 'members' => [ 'message' => [ 'shape' => 'String', ], ], 'error' => [ 'httpStatusCode' => 400, 'senderFault' => true, ], 'exception' => true, ], 'EndpointName' => [ 'type' => 'string', 'pattern' => '[a-zA-Z][a-zA-Z0-9_]{0,47}', 'sensitive' => true, ], 'EnvironmentVariableKey' => [ 'type' => 'string', 'max' => 100, 'min' => 1, ], 'EnvironmentVariableValue' => [ 'type' => 'string', 'max' => 5000, 'min' => 0, ], 'EnvironmentVariablesMap' => [ 'type' => 'map', 'key' => [ 'shape' => 'EnvironmentVariableKey', ], 'value' => [ 'shape' => 'EnvironmentVariableValue', ], 'max' => 50, 'min' => 0, 'sensitive' => true, ], 'ExceptionLevel' => [ 'type' => 'string', 'enum' => [ 'DEBUG', ], ], 'ExtractionConfiguration' => [ 'type' => 'structure', 'members' => [ 'customExtractionConfiguration' => [ 'shape' => 'CustomExtractionConfiguration', ], ], 'union' => true, ], 'GatewayArn' => [ 'type' => 'string', 'pattern' => 'arn:aws(|-cn|-us-gov):bedrock-agentcore:[a-z0-9-]{1,20}:[0-9]{12}:gateway/[0-9a-zA-Z]{10}', ], 'GatewayDescription' => [ 'type' => 'string', 'max' => 200, 'min' => 1, 'sensitive' => true, ], 'GatewayId' => [ 'type' => 'string', 'pattern' => '([0-9a-z][-]?){1,100}-[0-9a-z]{10}', ], 'GatewayIdentifier' => [ 'type' => 'string', 'pattern' => '([0-9a-z][-]?){1,100}-[0-9a-z]{10}', ], 'GatewayInterceptionPoint' => [ 'type' => 'string', 'enum' => [ 'REQUEST', 'RESPONSE', ], ], 'GatewayInterceptionPoints' => [ 'type' => 'list', 'member' => [ 'shape' => 'GatewayInterceptionPoint', ], 'max' => 2, 'min' => 1, ], 'GatewayInterceptorConfiguration' => [ 'type' => 'structure', 'required' => [ 'interceptor', 'interceptionPoints', ], 'members' => [ 'interceptor' => [ 'shape' => 'InterceptorConfiguration', ], 'interceptionPoints' => [ 'shape' => 'GatewayInterceptionPoints', ], 'inputConfiguration' => [ 'shape' => 'InterceptorInputConfiguration', ], ], ], 'GatewayInterceptorConfigurations' => [ 'type' => 'list', 'member' => [ 'shape' => 'GatewayInterceptorConfiguration', ], 'max' => 2, 'min' => 1, ], 'GatewayMaxResults' => [ 'type' => 'integer', 'box' => true, 'max' => 1000, 'min' => 1, ], 'GatewayName' => [ 'type' => 'string', 'pattern' => '([0-9a-zA-Z][-]?){1,100}', 'sensitive' => true, ], 'GatewayNextToken' => [ 'type' => 'string', 'max' => 2048, 'min' => 1, 'pattern' => '\\S*', ], 'GatewayProtocolConfiguration' => [ 'type' => 'structure', 'members' => [ 'mcp' => [ 'shape' => 'MCPGatewayConfiguration', ], ], 'union' => true, ], 'GatewayProtocolType' => [ 'type' => 'string', 'enum' => [ 'MCP', ], ], 'GatewayStatus' => [ 'type' => 'string', 'enum' => [ 'CREATING', 'UPDATING', 'UPDATE_UNSUCCESSFUL', 'DELETING', 'READY', 'FAILED', ], ], 'GatewaySummaries' => [ 'type' => 'list', 'member' => [ 'shape' => 'GatewaySummary', ], ], 'GatewaySummary' => [ 'type' => 'structure', 'required' => [ 'gatewayId', 'name', 'status', 'createdAt', 'updatedAt', 'authorizerType', 'protocolType', ], 'members' => [ 'gatewayId' => [ 'shape' => 'GatewayId', ], 'name' => [ 'shape' => 'GatewayName', ], 'status' => [ 'shape' => 'GatewayStatus', ], 'description' => [ 'shape' => 'GatewayDescription', ], 'createdAt' => [ 'shape' => 'DateTimestamp', ], 'updatedAt' => [ 'shape' => 'DateTimestamp', ], 'authorizerType' => [ 'shape' => 'AuthorizerType', ], 'protocolType' => [ 'shape' => 'GatewayProtocolType', ], ], ], 'GatewayTarget' => [ 'type' => 'structure', 'required' => [ 'gatewayArn', 'targetId', 'createdAt', 'updatedAt', 'status', 'name', 'targetConfiguration', 'credentialProviderConfigurations', ], 'members' => [ 'gatewayArn' => [ 'shape' => 'GatewayArn', ], 'targetId' => [ 'shape' => 'TargetId', ], 'createdAt' => [ 'shape' => 'DateTimestamp', ], 'updatedAt' => [ 'shape' => 'DateTimestamp', ], 'status' => [ 'shape' => 'TargetStatus', ], 'statusReasons' => [ 'shape' => 'StatusReasons', ], 'name' => [ 'shape' => 'TargetName', ], 'description' => [ 'shape' => 'TargetDescription', ], 'targetConfiguration' => [ 'shape' => 'TargetConfiguration', ], 'credentialProviderConfigurations' => [ 'shape' => 'CredentialProviderConfigurations', ], 'lastSynchronizedAt' => [ 'shape' => 'DateTimestamp', ], ], ], 'GatewayTargetList' => [ 'type' => 'list', 'member' => [ 'shape' => 'GatewayTarget', ], ], 'GatewayUrl' => [ 'type' => 'string', 'max' => 1024, 'min' => 1, ], 'GetAgentRuntimeEndpointRequest' => [ 'type' => 'structure', 'required' => [ 'agentRuntimeId', 'endpointName', ], 'members' => [ 'agentRuntimeId' => [ 'shape' => 'AgentRuntimeId', 'location' => 'uri', 'locationName' => 'agentRuntimeId', ], 'endpointName' => [ 'shape' => 'EndpointName', 'location' => 'uri', 'locationName' => 'endpointName', ], ], ], 'GetAgentRuntimeEndpointResponse' => [ 'type' => 'structure', 'required' => [ 'agentRuntimeEndpointArn', 'agentRuntimeArn', 'status', 'createdAt', 'lastUpdatedAt', 'name', 'id', ], 'members' => [ 'liveVersion' => [ 'shape' => 'AgentRuntimeVersion', ], 'targetVersion' => [ 'shape' => 'AgentRuntimeVersion', ], 'agentRuntimeEndpointArn' => [ 'shape' => 'AgentRuntimeEndpointArn', ], 'agentRuntimeArn' => [ 'shape' => 'AgentRuntimeArn', ], 'description' => [ 'shape' => 'AgentEndpointDescription', ], 'status' => [ 'shape' => 'AgentRuntimeEndpointStatus', ], 'createdAt' => [ 'shape' => 'DateTimestamp', ], 'lastUpdatedAt' => [ 'shape' => 'DateTimestamp', ], 'failureReason' => [ 'shape' => 'String', ], 'name' => [ 'shape' => 'EndpointName', ], 'id' => [ 'shape' => 'AgentRuntimeEndpointId', ], ], ], 'GetAgentRuntimeRequest' => [ 'type' => 'structure', 'required' => [ 'agentRuntimeId', ], 'members' => [ 'agentRuntimeId' => [ 'shape' => 'AgentRuntimeId', 'location' => 'uri', 'locationName' => 'agentRuntimeId', ], 'agentRuntimeVersion' => [ 'shape' => 'AgentRuntimeVersion', 'location' => 'querystring', 'locationName' => 'version', ], ], ], 'GetAgentRuntimeResponse' => [ 'type' => 'structure', 'required' => [ 'agentRuntimeArn', 'agentRuntimeName', 'agentRuntimeId', 'agentRuntimeVersion', 'createdAt', 'lastUpdatedAt', 'roleArn', 'networkConfiguration', 'status', 'lifecycleConfiguration', ], 'members' => [ 'agentRuntimeArn' => [ 'shape' => 'AgentRuntimeArn', ], 'agentRuntimeName' => [ 'shape' => 'AgentRuntimeName', ], 'agentRuntimeId' => [ 'shape' => 'AgentRuntimeId', ], 'agentRuntimeVersion' => [ 'shape' => 'AgentRuntimeVersion', ], 'createdAt' => [ 'shape' => 'DateTimestamp', ], 'lastUpdatedAt' => [ 'shape' => 'DateTimestamp', ], 'roleArn' => [ 'shape' => 'RoleArn', ], 'networkConfiguration' => [ 'shape' => 'NetworkConfiguration', ], 'status' => [ 'shape' => 'AgentRuntimeStatus', ], 'lifecycleConfiguration' => [ 'shape' => 'LifecycleConfiguration', ], 'description' => [ 'shape' => 'Description', ], 'workloadIdentityDetails' => [ 'shape' => 'WorkloadIdentityDetails', ], 'agentRuntimeArtifact' => [ 'shape' => 'AgentRuntimeArtifact', ], 'protocolConfiguration' => [ 'shape' => 'ProtocolConfiguration', ], 'environmentVariables' => [ 'shape' => 'EnvironmentVariablesMap', ], 'authorizerConfiguration' => [ 'shape' => 'AuthorizerConfiguration', ], 'requestHeaderConfiguration' => [ 'shape' => 'RequestHeaderConfiguration', ], ], ], 'GetApiKeyCredentialProviderRequest' => [ 'type' => 'structure', 'required' => [ 'name', ], 'members' => [ 'name' => [ 'shape' => 'CredentialProviderName', ], ], ], 'GetApiKeyCredentialProviderResponse' => [ 'type' => 'structure', 'required' => [ 'apiKeySecretArn', 'name', 'credentialProviderArn', 'createdTime', 'lastUpdatedTime', ], 'members' => [ 'apiKeySecretArn' => [ 'shape' => 'Secret', ], 'name' => [ 'shape' => 'CredentialProviderName', ], 'credentialProviderArn' => [ 'shape' => 'ApiKeyCredentialProviderArnType', ], 'createdTime' => [ 'shape' => 'Timestamp', ], 'lastUpdatedTime' => [ 'shape' => 'Timestamp', ], ], ], 'GetBrowserRequest' => [ 'type' => 'structure', 'required' => [ 'browserId', ], 'members' => [ 'browserId' => [ 'shape' => 'BrowserId', 'location' => 'uri', 'locationName' => 'browserId', ], ], ], 'GetBrowserResponse' => [ 'type' => 'structure', 'required' => [ 'browserId', 'browserArn', 'name', 'networkConfiguration', 'status', 'createdAt', 'lastUpdatedAt', ], 'members' => [ 'browserId' => [ 'shape' => 'BrowserId', ], 'browserArn' => [ 'shape' => 'BrowserArn', ], 'name' => [ 'shape' => 'SandboxName', ], 'description' => [ 'shape' => 'Description', ], 'executionRoleArn' => [ 'shape' => 'RoleArn', ], 'networkConfiguration' => [ 'shape' => 'BrowserNetworkConfiguration', ], 'recording' => [ 'shape' => 'RecordingConfig', ], 'browserSigning' => [ 'shape' => 'BrowserSigningConfigOutput', ], 'status' => [ 'shape' => 'BrowserStatus', ], 'failureReason' => [ 'shape' => 'String', ], 'createdAt' => [ 'shape' => 'DateTimestamp', ], 'lastUpdatedAt' => [ 'shape' => 'DateTimestamp', ], ], ], 'GetCodeInterpreterRequest' => [ 'type' => 'structure', 'required' => [ 'codeInterpreterId', ], 'members' => [ 'codeInterpreterId' => [ 'shape' => 'CodeInterpreterId', 'location' => 'uri', 'locationName' => 'codeInterpreterId', ], ], ], 'GetCodeInterpreterResponse' => [ 'type' => 'structure', 'required' => [ 'codeInterpreterId', 'codeInterpreterArn', 'name', 'networkConfiguration', 'status', 'createdAt', 'lastUpdatedAt', ], 'members' => [ 'codeInterpreterId' => [ 'shape' => 'CodeInterpreterId', ], 'codeInterpreterArn' => [ 'shape' => 'CodeInterpreterArn', ], 'name' => [ 'shape' => 'SandboxName', ], 'description' => [ 'shape' => 'Description', ], 'executionRoleArn' => [ 'shape' => 'RoleArn', ], 'networkConfiguration' => [ 'shape' => 'CodeInterpreterNetworkConfiguration', ], 'status' => [ 'shape' => 'CodeInterpreterStatus', ], 'failureReason' => [ 'shape' => 'String', ], 'createdAt' => [ 'shape' => 'DateTimestamp', ], 'lastUpdatedAt' => [ 'shape' => 'DateTimestamp', ], ], ], 'GetGatewayRequest' => [ 'type' => 'structure', 'required' => [ 'gatewayIdentifier', ], 'members' => [ 'gatewayIdentifier' => [ 'shape' => 'GatewayIdentifier', 'location' => 'uri', 'locationName' => 'gatewayIdentifier', ], ], ], 'GetGatewayResponse' => [ 'type' => 'structure', 'required' => [ 'gatewayArn', 'gatewayId', 'createdAt', 'updatedAt', 'status', 'name', 'protocolType', 'authorizerType', ], 'members' => [ 'gatewayArn' => [ 'shape' => 'GatewayArn', ], 'gatewayId' => [ 'shape' => 'GatewayId', ], 'gatewayUrl' => [ 'shape' => 'GatewayUrl', ], 'createdAt' => [ 'shape' => 'DateTimestamp', ], 'updatedAt' => [ 'shape' => 'DateTimestamp', ], 'status' => [ 'shape' => 'GatewayStatus', ], 'statusReasons' => [ 'shape' => 'StatusReasons', ], 'name' => [ 'shape' => 'GatewayName', ], 'description' => [ 'shape' => 'GatewayDescription', ], 'roleArn' => [ 'shape' => 'RoleArn', ], 'protocolType' => [ 'shape' => 'GatewayProtocolType', ], 'protocolConfiguration' => [ 'shape' => 'GatewayProtocolConfiguration', ], 'authorizerType' => [ 'shape' => 'AuthorizerType', ], 'authorizerConfiguration' => [ 'shape' => 'AuthorizerConfiguration', ], 'kmsKeyArn' => [ 'shape' => 'KmsKeyArn', ], 'interceptorConfigurations' => [ 'shape' => 'GatewayInterceptorConfigurations', ], 'workloadIdentityDetails' => [ 'shape' => 'WorkloadIdentityDetails', ], 'exceptionLevel' => [ 'shape' => 'ExceptionLevel', ], ], ], 'GetGatewayTargetRequest' => [ 'type' => 'structure', 'required' => [ 'gatewayIdentifier', 'targetId', ], 'members' => [ 'gatewayIdentifier' => [ 'shape' => 'GatewayIdentifier', 'location' => 'uri', 'locationName' => 'gatewayIdentifier', ], 'targetId' => [ 'shape' => 'TargetId', 'location' => 'uri', 'locationName' => 'targetId', ], ], ], 'GetGatewayTargetResponse' => [ 'type' => 'structure', 'required' => [ 'gatewayArn', 'targetId', 'createdAt', 'updatedAt', 'status', 'name', 'targetConfiguration', 'credentialProviderConfigurations', ], 'members' => [ 'gatewayArn' => [ 'shape' => 'GatewayArn', ], 'targetId' => [ 'shape' => 'TargetId', ], 'createdAt' => [ 'shape' => 'DateTimestamp', ], 'updatedAt' => [ 'shape' => 'DateTimestamp', ], 'status' => [ 'shape' => 'TargetStatus', ], 'statusReasons' => [ 'shape' => 'StatusReasons', ], 'name' => [ 'shape' => 'TargetName', ], 'description' => [ 'shape' => 'TargetDescription', ], 'targetConfiguration' => [ 'shape' => 'TargetConfiguration', ], 'credentialProviderConfigurations' => [ 'shape' => 'CredentialProviderConfigurations', ], 'lastSynchronizedAt' => [ 'shape' => 'DateTimestamp', ], ], ], 'GetMemoryInput' => [ 'type' => 'structure', 'required' => [ 'memoryId', ], 'members' => [ 'memoryId' => [ 'shape' => 'MemoryId', 'location' => 'uri', 'locationName' => 'memoryId', ], ], ], 'GetMemoryOutput' => [ 'type' => 'structure', 'required' => [ 'memory', ], 'members' => [ 'memory' => [ 'shape' => 'Memory', ], ], ], 'GetOauth2CredentialProviderRequest' => [ 'type' => 'structure', 'required' => [ 'name', ], 'members' => [ 'name' => [ 'shape' => 'CredentialProviderName', ], ], ], 'GetOauth2CredentialProviderResponse' => [ 'type' => 'structure', 'required' => [ 'clientSecretArn', 'name', 'credentialProviderArn', 'credentialProviderVendor', 'oauth2ProviderConfigOutput', 'createdTime', 'lastUpdatedTime', ], 'members' => [ 'clientSecretArn' => [ 'shape' => 'Secret', ], 'name' => [ 'shape' => 'CredentialProviderName', ], 'credentialProviderArn' => [ 'shape' => 'CredentialProviderArnType', ], 'credentialProviderVendor' => [ 'shape' => 'CredentialProviderVendorType', ], 'callbackUrl' => [ 'shape' => 'String', ], 'oauth2ProviderConfigOutput' => [ 'shape' => 'Oauth2ProviderConfigOutput', ], 'createdTime' => [ 'shape' => 'Timestamp', ], 'lastUpdatedTime' => [ 'shape' => 'Timestamp', ], ], ], 'GetTokenVaultRequest' => [ 'type' => 'structure', 'members' => [ 'tokenVaultId' => [ 'shape' => 'TokenVaultIdType', ], ], ], 'GetTokenVaultResponse' => [ 'type' => 'structure', 'required' => [ 'tokenVaultId', 'kmsConfiguration', 'lastModifiedDate', ], 'members' => [ 'tokenVaultId' => [ 'shape' => 'TokenVaultIdType', ], 'kmsConfiguration' => [ 'shape' => 'KmsConfiguration', ], 'lastModifiedDate' => [ 'shape' => 'Timestamp', ], ], ], 'GetWorkloadIdentityRequest' => [ 'type' => 'structure', 'required' => [ 'name', ], 'members' => [ 'name' => [ 'shape' => 'WorkloadIdentityNameType', ], ], ], 'GetWorkloadIdentityResponse' => [ 'type' => 'structure', 'required' => [ 'name', 'workloadIdentityArn', 'createdTime', 'lastUpdatedTime', ], 'members' => [ 'name' => [ 'shape' => 'WorkloadIdentityNameType', ], 'workloadIdentityArn' => [ 'shape' => 'WorkloadIdentityArnType', ], 'allowedResourceOauth2ReturnUrls' => [ 'shape' => 'ResourceOauth2ReturnUrlListType', ], 'createdTime' => [ 'shape' => 'Timestamp', ], 'lastUpdatedTime' => [ 'shape' => 'Timestamp', ], ], ], 'GithubOauth2ProviderConfigInput' => [ 'type' => 'structure', 'required' => [ 'clientId', 'clientSecret', ], 'members' => [ 'clientId' => [ 'shape' => 'ClientIdType', ], 'clientSecret' => [ 'shape' => 'ClientSecretType', ], ], ], 'GithubOauth2ProviderConfigOutput' => [ 'type' => 'structure', 'required' => [ 'oauthDiscovery', ], 'members' => [ 'oauthDiscovery' => [ 'shape' => 'Oauth2Discovery', ], 'clientId' => [ 'shape' => 'ClientIdType', ], ], ], 'GoogleOauth2ProviderConfigInput' => [ 'type' => 'structure', 'required' => [ 'clientId', 'clientSecret', ], 'members' => [ 'clientId' => [ 'shape' => 'ClientIdType', ], 'clientSecret' => [ 'shape' => 'ClientSecretType', ], ], ], 'GoogleOauth2ProviderConfigOutput' => [ 'type' => 'structure', 'required' => [ 'oauthDiscovery', ], 'members' => [ 'oauthDiscovery' => [ 'shape' => 'Oauth2Discovery', ], 'clientId' => [ 'shape' => 'ClientIdType', ], ], ], 'HeaderName' => [ 'type' => 'string', 'max' => 256, 'min' => 1, 'pattern' => '(Authorization|X-Amzn-Bedrock-AgentCore-Runtime-Custom-[a-zA-Z0-9-]+)', ], 'IncludedOauth2ProviderConfigInput' => [ 'type' => 'structure', 'required' => [ 'clientId', 'clientSecret', ], 'members' => [ 'clientId' => [ 'shape' => 'ClientIdType', ], 'clientSecret' => [ 'shape' => 'ClientSecretType', ], 'issuer' => [ 'shape' => 'IssuerUrlType', ], 'authorizationEndpoint' => [ 'shape' => 'AuthorizationEndpointType', ], 'tokenEndpoint' => [ 'shape' => 'TokenEndpointType', ], ], ], 'IncludedOauth2ProviderConfigOutput' => [ 'type' => 'structure', 'required' => [ 'oauthDiscovery', ], 'members' => [ 'oauthDiscovery' => [ 'shape' => 'Oauth2Discovery', ], 'clientId' => [ 'shape' => 'ClientIdType', ], ], ], 'InlinePayload' => [ 'type' => 'string', 'sensitive' => true, ], 'Integer' => [ 'type' => 'integer', 'box' => true, ], 'InterceptorConfiguration' => [ 'type' => 'structure', 'members' => [ 'lambda' => [ 'shape' => 'LambdaInterceptorConfiguration', ], ], 'union' => true, ], 'InterceptorInputConfiguration' => [ 'type' => 'structure', 'required' => [ 'passRequestHeaders', ], 'members' => [ 'passRequestHeaders' => [ 'shape' => 'Boolean', ], ], ], 'InternalServerException' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'NonBlankString', ], ], 'error' => [ 'httpStatusCode' => 500, ], 'exception' => true, 'fault' => true, ], 'InvocationConfiguration' => [ 'type' => 'structure', 'required' => [ 'topicArn', 'payloadDeliveryBucketName', ], 'members' => [ 'topicArn' => [ 'shape' => 'Arn', ], 'payloadDeliveryBucketName' => [ 'shape' => 'String', ], ], ], 'InvocationConfigurationInput' => [ 'type' => 'structure', 'required' => [ 'topicArn', 'payloadDeliveryBucketName', ], 'members' => [ 'topicArn' => [ 'shape' => 'Arn', ], 'payloadDeliveryBucketName' => [ 'shape' => 'InvocationConfigurationInputPayloadDeliveryBucketNameString', ], ], ], 'InvocationConfigurationInputPayloadDeliveryBucketNameString' => [ 'type' => 'string', 'pattern' => '[a-z0-9][a-z0-9.-]{1,61}[a-z0-9]', ], 'IssuerUrlType' => [ 'type' => 'string', ], 'KeyType' => [ 'type' => 'string', 'enum' => [ 'CustomerManagedKey', 'ServiceManagedKey', ], ], 'KmsConfiguration' => [ 'type' => 'structure', 'required' => [ 'keyType', ], 'members' => [ 'keyType' => [ 'shape' => 'KeyType', ], 'kmsKeyArn' => [ 'shape' => 'KmsKeyArn', ], ], ], 'KmsKeyArn' => [ 'type' => 'string', 'max' => 2048, 'min' => 1, 'pattern' => 'arn:aws(|-cn|-us-gov):kms:[a-zA-Z0-9-]*:[0-9]{12}:key/[a-zA-Z0-9-]{36}', ], 'LambdaFunctionArn' => [ 'type' => 'string', 'max' => 170, 'min' => 1, 'pattern' => 'arn:(aws[a-zA-Z-]*)?:lambda:([a-z]{2}(-gov)?-[a-z]+-\\d{1}):(\\d{12}):function:([a-zA-Z0-9-_.]+)(:(\\$LATEST|[a-zA-Z0-9-]+))?', ], 'LambdaInterceptorConfiguration' => [ 'type' => 'structure', 'required' => [ 'arn', ], 'members' => [ 'arn' => [ 'shape' => 'LambdaFunctionArn', ], ], ], 'LifecycleConfiguration' => [ 'type' => 'structure', 'members' => [ 'idleRuntimeSessionTimeout' => [ 'shape' => 'LifecycleConfigurationIdleRuntimeSessionTimeoutInteger', ], 'maxLifetime' => [ 'shape' => 'LifecycleConfigurationMaxLifetimeInteger', ], ], ], 'LifecycleConfigurationIdleRuntimeSessionTimeoutInteger' => [ 'type' => 'integer', 'box' => true, 'max' => 28800, 'min' => 60, ], 'LifecycleConfigurationMaxLifetimeInteger' => [ 'type' => 'integer', 'box' => true, 'max' => 28800, 'min' => 60, ], 'LinkedinOauth2ProviderConfigInput' => [ 'type' => 'structure', 'required' => [ 'clientId', 'clientSecret', ], 'members' => [ 'clientId' => [ 'shape' => 'ClientIdType', ], 'clientSecret' => [ 'shape' => 'ClientSecretType', ], ], ], 'LinkedinOauth2ProviderConfigOutput' => [ 'type' => 'structure', 'required' => [ 'oauthDiscovery', ], 'members' => [ 'oauthDiscovery' => [ 'shape' => 'Oauth2Discovery', ], 'clientId' => [ 'shape' => 'ClientIdType', ], ], ], 'ListAgentRuntimeEndpointsRequest' => [ 'type' => 'structure', 'required' => [ 'agentRuntimeId', ], 'members' => [ 'agentRuntimeId' => [ 'shape' => 'AgentRuntimeId', 'location' => 'uri', 'locationName' => 'agentRuntimeId', ], 'maxResults' => [ 'shape' => 'MaxResults', 'location' => 'querystring', 'locationName' => 'maxResults', ], 'nextToken' => [ 'shape' => 'NextToken', 'location' => 'querystring', 'locationName' => 'nextToken', ], ], ], 'ListAgentRuntimeEndpointsResponse' => [ 'type' => 'structure', 'required' => [ 'runtimeEndpoints', ], 'members' => [ 'runtimeEndpoints' => [ 'shape' => 'AgentRuntimeEndpoints', ], 'nextToken' => [ 'shape' => 'NextToken', ], ], ], 'ListAgentRuntimeVersionsRequest' => [ 'type' => 'structure', 'required' => [ 'agentRuntimeId', ], 'members' => [ 'agentRuntimeId' => [ 'shape' => 'AgentRuntimeId', 'location' => 'uri', 'locationName' => 'agentRuntimeId', ], 'maxResults' => [ 'shape' => 'MaxResults', 'location' => 'querystring', 'locationName' => 'maxResults', ], 'nextToken' => [ 'shape' => 'NextToken', 'location' => 'querystring', 'locationName' => 'nextToken', ], ], ], 'ListAgentRuntimeVersionsResponse' => [ 'type' => 'structure', 'required' => [ 'agentRuntimes', ], 'members' => [ 'agentRuntimes' => [ 'shape' => 'AgentRuntimes', ], 'nextToken' => [ 'shape' => 'NextToken', ], ], ], 'ListAgentRuntimesRequest' => [ 'type' => 'structure', 'members' => [ 'maxResults' => [ 'shape' => 'MaxResults', 'location' => 'querystring', 'locationName' => 'maxResults', ], 'nextToken' => [ 'shape' => 'NextToken', 'location' => 'querystring', 'locationName' => 'nextToken', ], ], ], 'ListAgentRuntimesResponse' => [ 'type' => 'structure', 'required' => [ 'agentRuntimes', ], 'members' => [ 'agentRuntimes' => [ 'shape' => 'AgentRuntimes', ], 'nextToken' => [ 'shape' => 'NextToken', ], ], ], 'ListApiKeyCredentialProvidersRequest' => [ 'type' => 'structure', 'members' => [ 'nextToken' => [ 'shape' => 'String', ], 'maxResults' => [ 'shape' => 'MaxResults', ], ], ], 'ListApiKeyCredentialProvidersResponse' => [ 'type' => 'structure', 'required' => [ 'credentialProviders', ], 'members' => [ 'credentialProviders' => [ 'shape' => 'ApiKeyCredentialProviders', ], 'nextToken' => [ 'shape' => 'String', ], ], ], 'ListBrowsersRequest' => [ 'type' => 'structure', 'members' => [ 'maxResults' => [ 'shape' => 'MaxResults', 'location' => 'querystring', 'locationName' => 'maxResults', ], 'nextToken' => [ 'shape' => 'NextToken', 'location' => 'querystring', 'locationName' => 'nextToken', ], 'type' => [ 'shape' => 'ResourceType', 'location' => 'querystring', 'locationName' => 'type', ], ], ], 'ListBrowsersResponse' => [ 'type' => 'structure', 'required' => [ 'browserSummaries', ], 'members' => [ 'browserSummaries' => [ 'shape' => 'BrowserSummaries', ], 'nextToken' => [ 'shape' => 'NextToken', ], ], ], 'ListCodeInterpretersRequest' => [ 'type' => 'structure', 'members' => [ 'maxResults' => [ 'shape' => 'MaxResults', 'location' => 'querystring', 'locationName' => 'maxResults', ], 'nextToken' => [ 'shape' => 'NextToken', 'location' => 'querystring', 'locationName' => 'nextToken', ], 'type' => [ 'shape' => 'ResourceType', 'location' => 'querystring', 'locationName' => 'type', ], ], ], 'ListCodeInterpretersResponse' => [ 'type' => 'structure', 'required' => [ 'codeInterpreterSummaries', ], 'members' => [ 'codeInterpreterSummaries' => [ 'shape' => 'CodeInterpreterSummaries', ], 'nextToken' => [ 'shape' => 'NextToken', ], ], ], 'ListGatewayTargetsRequest' => [ 'type' => 'structure', 'required' => [ 'gatewayIdentifier', ], 'members' => [ 'gatewayIdentifier' => [ 'shape' => 'GatewayIdentifier', 'location' => 'uri', 'locationName' => 'gatewayIdentifier', ], 'maxResults' => [ 'shape' => 'TargetMaxResults', 'location' => 'querystring', 'locationName' => 'maxResults', ], 'nextToken' => [ 'shape' => 'TargetNextToken', 'location' => 'querystring', 'locationName' => 'nextToken', ], ], ], 'ListGatewayTargetsResponse' => [ 'type' => 'structure', 'required' => [ 'items', ], 'members' => [ 'items' => [ 'shape' => 'TargetSummaries', ], 'nextToken' => [ 'shape' => 'TargetNextToken', ], ], ], 'ListGatewaysRequest' => [ 'type' => 'structure', 'members' => [ 'maxResults' => [ 'shape' => 'GatewayMaxResults', 'location' => 'querystring', 'locationName' => 'maxResults', ], 'nextToken' => [ 'shape' => 'GatewayNextToken', 'location' => 'querystring', 'locationName' => 'nextToken', ], ], ], 'ListGatewaysResponse' => [ 'type' => 'structure', 'required' => [ 'items', ], 'members' => [ 'items' => [ 'shape' => 'GatewaySummaries', ], 'nextToken' => [ 'shape' => 'GatewayNextToken', ], ], ], 'ListMemoriesInput' => [ 'type' => 'structure', 'members' => [ 'maxResults' => [ 'shape' => 'ListMemoriesInputMaxResultsInteger', ], 'nextToken' => [ 'shape' => 'String', ], ], ], 'ListMemoriesInputMaxResultsInteger' => [ 'type' => 'integer', 'box' => true, 'max' => 100, 'min' => 1, ], 'ListMemoriesOutput' => [ 'type' => 'structure', 'required' => [ 'memories', ], 'members' => [ 'memories' => [ 'shape' => 'MemorySummaryList', ], 'nextToken' => [ 'shape' => 'String', ], ], ], 'ListOauth2CredentialProvidersRequest' => [ 'type' => 'structure', 'members' => [ 'nextToken' => [ 'shape' => 'String', ], 'maxResults' => [ 'shape' => 'ListOauth2CredentialProvidersRequestMaxResultsInteger', ], ], ], 'ListOauth2CredentialProvidersRequestMaxResultsInteger' => [ 'type' => 'integer', 'box' => true, 'max' => 20, 'min' => 1, ], 'ListOauth2CredentialProvidersResponse' => [ 'type' => 'structure', 'required' => [ 'credentialProviders', ], 'members' => [ 'credentialProviders' => [ 'shape' => 'Oauth2CredentialProviders', ], 'nextToken' => [ 'shape' => 'String', ], ], ], 'ListTagsForResourceRequest' => [ 'type' => 'structure', 'required' => [ 'resourceArn', ], 'members' => [ 'resourceArn' => [ 'shape' => 'TaggableResourcesArn', 'location' => 'uri', 'locationName' => 'resourceArn', ], ], ], 'ListTagsForResourceResponse' => [ 'type' => 'structure', 'members' => [ 'tags' => [ 'shape' => 'TagsMap', ], ], ], 'ListWorkloadIdentitiesRequest' => [ 'type' => 'structure', 'members' => [ 'nextToken' => [ 'shape' => 'String', ], 'maxResults' => [ 'shape' => 'ListWorkloadIdentitiesRequestMaxResultsInteger', ], ], ], 'ListWorkloadIdentitiesRequestMaxResultsInteger' => [ 'type' => 'integer', 'box' => true, 'max' => 20, 'min' => 1, ], 'ListWorkloadIdentitiesResponse' => [ 'type' => 'structure', 'required' => [ 'workloadIdentities', ], 'members' => [ 'workloadIdentities' => [ 'shape' => 'WorkloadIdentityList', ], 'nextToken' => [ 'shape' => 'String', ], ], ], 'MCPGatewayConfiguration' => [ 'type' => 'structure', 'members' => [ 'supportedVersions' => [ 'shape' => 'McpSupportedVersions', ], 'instructions' => [ 'shape' => 'McpInstructions', ], 'searchType' => [ 'shape' => 'SearchType', ], ], ], 'MaxResults' => [ 'type' => 'integer', 'box' => true, 'max' => 100, 'min' => 1, ], 'McpInstructions' => [ 'type' => 'string', 'max' => 2048, 'min' => 1, ], 'McpLambdaTargetConfiguration' => [ 'type' => 'structure', 'required' => [ 'lambdaArn', 'toolSchema', ], 'members' => [ 'lambdaArn' => [ 'shape' => 'LambdaFunctionArn', ], 'toolSchema' => [ 'shape' => 'ToolSchema', ], ], ], 'McpServerTargetConfiguration' => [ 'type' => 'structure', 'required' => [ 'endpoint', ], 'members' => [ 'endpoint' => [ 'shape' => 'McpServerTargetConfigurationEndpointString', ], ], ], 'McpServerTargetConfigurationEndpointString' => [ 'type' => 'string', 'pattern' => 'https://.*', ], 'McpSupportedVersions' => [ 'type' => 'list', 'member' => [ 'shape' => 'McpVersion', ], ], 'McpTargetConfiguration' => [ 'type' => 'structure', 'members' => [ 'openApiSchema' => [ 'shape' => 'ApiSchemaConfiguration', ], 'smithyModel' => [ 'shape' => 'ApiSchemaConfiguration', ], 'lambda' => [ 'shape' => 'McpLambdaTargetConfiguration', ], 'mcpServer' => [ 'shape' => 'McpServerTargetConfiguration', ], ], 'union' => true, ], 'McpVersion' => [ 'type' => 'string', ], 'Memory' => [ 'type' => 'structure', 'required' => [ 'arn', 'id', 'name', 'eventExpiryDuration', 'status', 'createdAt', 'updatedAt', ], 'members' => [ 'arn' => [ 'shape' => 'MemoryArn', ], 'id' => [ 'shape' => 'MemoryId', ], 'name' => [ 'shape' => 'Name', ], 'description' => [ 'shape' => 'Description', ], 'encryptionKeyArn' => [ 'shape' => 'Arn', ], 'memoryExecutionRoleArn' => [ 'shape' => 'Arn', ], 'eventExpiryDuration' => [ 'shape' => 'MemoryEventExpiryDurationInteger', ], 'status' => [ 'shape' => 'MemoryStatus', ], 'failureReason' => [ 'shape' => 'String', ], 'createdAt' => [ 'shape' => 'Timestamp', ], 'updatedAt' => [ 'shape' => 'Timestamp', ], 'strategies' => [ 'shape' => 'MemoryStrategyList', ], ], ], 'MemoryArn' => [ 'type' => 'string', 'pattern' => 'arn:aws:bedrock-agentcore:[a-z0-9-]+:[0-9]{12}:memory\\/[a-zA-Z][a-zA-Z0-9-_]{0,99}-[a-zA-Z0-9]{10}', ], 'MemoryEventExpiryDurationInteger' => [ 'type' => 'integer', 'box' => true, 'max' => 365, 'min' => 1, ], 'MemoryId' => [ 'type' => 'string', 'min' => 12, 'pattern' => '[a-zA-Z][a-zA-Z0-9-_]{0,99}-[a-zA-Z0-9]{10}', ], 'MemoryStatus' => [ 'type' => 'string', 'enum' => [ 'CREATING', 'ACTIVE', 'FAILED', 'DELETING', ], ], 'MemoryStrategy' => [ 'type' => 'structure', 'required' => [ 'strategyId', 'name', 'type', 'namespaces', ], 'members' => [ 'strategyId' => [ 'shape' => 'MemoryStrategyId', ], 'name' => [ 'shape' => 'Name', ], 'description' => [ 'shape' => 'Description', ], 'configuration' => [ 'shape' => 'StrategyConfiguration', ], 'type' => [ 'shape' => 'MemoryStrategyType', ], 'namespaces' => [ 'shape' => 'NamespacesList', ], 'createdAt' => [ 'shape' => 'Timestamp', ], 'updatedAt' => [ 'shape' => 'Timestamp', ], 'status' => [ 'shape' => 'MemoryStrategyStatus', ], ], ], 'MemoryStrategyId' => [ 'type' => 'string', 'min' => 12, 'pattern' => '[a-zA-Z][a-zA-Z0-9-_]{0,99}-[a-zA-Z0-9]{10}', ], 'MemoryStrategyInput' => [ 'type' => 'structure', 'members' => [ 'semanticMemoryStrategy' => [ 'shape' => 'SemanticMemoryStrategyInput', ], 'summaryMemoryStrategy' => [ 'shape' => 'SummaryMemoryStrategyInput', ], 'userPreferenceMemoryStrategy' => [ 'shape' => 'UserPreferenceMemoryStrategyInput', ], 'customMemoryStrategy' => [ 'shape' => 'CustomMemoryStrategyInput', ], ], 'union' => true, ], 'MemoryStrategyInputList' => [ 'type' => 'list', 'member' => [ 'shape' => 'MemoryStrategyInput', ], ], 'MemoryStrategyList' => [ 'type' => 'list', 'member' => [ 'shape' => 'MemoryStrategy', ], ], 'MemoryStrategyStatus' => [ 'type' => 'string', 'enum' => [ 'CREATING', 'ACTIVE', 'DELETING', 'FAILED', ], ], 'MemoryStrategyType' => [ 'type' => 'string', 'enum' => [ 'SEMANTIC', 'SUMMARIZATION', 'USER_PREFERENCE', 'CUSTOM', ], ], 'MemorySummary' => [ 'type' => 'structure', 'required' => [ 'createdAt', 'updatedAt', ], 'members' => [ 'arn' => [ 'shape' => 'MemoryArn', ], 'id' => [ 'shape' => 'MemoryId', ], 'status' => [ 'shape' => 'MemoryStatus', ], 'createdAt' => [ 'shape' => 'Timestamp', ], 'updatedAt' => [ 'shape' => 'Timestamp', ], ], ], 'MemorySummaryList' => [ 'type' => 'list', 'member' => [ 'shape' => 'MemorySummary', ], ], 'MessageBasedTrigger' => [ 'type' => 'structure', 'members' => [ 'messageCount' => [ 'shape' => 'Integer', ], ], ], 'MessageBasedTriggerInput' => [ 'type' => 'structure', 'members' => [ 'messageCount' => [ 'shape' => 'MessageBasedTriggerInputMessageCountInteger', ], ], ], 'MessageBasedTriggerInputMessageCountInteger' => [ 'type' => 'integer', 'box' => true, 'max' => 50, 'min' => 1, ], 'MicrosoftOauth2ProviderConfigInput' => [ 'type' => 'structure', 'required' => [ 'clientId', 'clientSecret', ], 'members' => [ 'clientId' => [ 'shape' => 'ClientIdType', ], 'clientSecret' => [ 'shape' => 'ClientSecretType', ], 'tenantId' => [ 'shape' => 'TenantIdType', ], ], ], 'MicrosoftOauth2ProviderConfigOutput' => [ 'type' => 'structure', 'required' => [ 'oauthDiscovery', ], 'members' => [ 'oauthDiscovery' => [ 'shape' => 'Oauth2Discovery', ], 'clientId' => [ 'shape' => 'ClientIdType', ], ], ], 'ModifyConsolidationConfiguration' => [ 'type' => 'structure', 'members' => [ 'customConsolidationConfiguration' => [ 'shape' => 'CustomConsolidationConfigurationInput', ], ], 'union' => true, ], 'ModifyExtractionConfiguration' => [ 'type' => 'structure', 'members' => [ 'customExtractionConfiguration' => [ 'shape' => 'CustomExtractionConfigurationInput', ], ], 'union' => true, ], 'ModifyInvocationConfigurationInput' => [ 'type' => 'structure', 'members' => [ 'topicArn' => [ 'shape' => 'Arn', ], 'payloadDeliveryBucketName' => [ 'shape' => 'ModifyInvocationConfigurationInputPayloadDeliveryBucketNameString', ], ], ], 'ModifyInvocationConfigurationInputPayloadDeliveryBucketNameString' => [ 'type' => 'string', 'pattern' => '[a-z0-9][a-z0-9.-]{1,61}[a-z0-9]', ], 'ModifyMemoryStrategies' => [ 'type' => 'structure', 'members' => [ 'addMemoryStrategies' => [ 'shape' => 'MemoryStrategyInputList', ], 'modifyMemoryStrategies' => [ 'shape' => 'ModifyMemoryStrategiesList', ], 'deleteMemoryStrategies' => [ 'shape' => 'DeleteMemoryStrategiesList', ], ], ], 'ModifyMemoryStrategiesList' => [ 'type' => 'list', 'member' => [ 'shape' => 'ModifyMemoryStrategyInput', ], ], 'ModifyMemoryStrategyInput' => [ 'type' => 'structure', 'required' => [ 'memoryStrategyId', ], 'members' => [ 'memoryStrategyId' => [ 'shape' => 'String', ], 'description' => [ 'shape' => 'Description', ], 'namespaces' => [ 'shape' => 'NamespacesList', ], 'configuration' => [ 'shape' => 'ModifyStrategyConfiguration', ], ], ], 'ModifySelfManagedConfiguration' => [ 'type' => 'structure', 'members' => [ 'triggerConditions' => [ 'shape' => 'TriggerConditionInputList', ], 'invocationConfiguration' => [ 'shape' => 'ModifyInvocationConfigurationInput', ], 'historicalContextWindowSize' => [ 'shape' => 'ModifySelfManagedConfigurationHistoricalContextWindowSizeInteger', ], ], ], 'ModifySelfManagedConfigurationHistoricalContextWindowSizeInteger' => [ 'type' => 'integer', 'box' => true, 'max' => 50, 'min' => 0, ], 'ModifyStrategyConfiguration' => [ 'type' => 'structure', 'members' => [ 'extraction' => [ 'shape' => 'ModifyExtractionConfiguration', ], 'consolidation' => [ 'shape' => 'ModifyConsolidationConfiguration', ], 'selfManagedConfiguration' => [ 'shape' => 'ModifySelfManagedConfiguration', ], ], ], 'Name' => [ 'type' => 'string', 'pattern' => '[a-zA-Z][a-zA-Z0-9_]{0,47}', ], 'Namespace' => [ 'type' => 'string', 'max' => 1024, 'min' => 1, 'pattern' => '[a-zA-Z0-9\\-_\\/]*(\\{(actorId|sessionId|memoryStrategyId)\\}[a-zA-Z0-9\\-_\\/]*)*', ], 'NamespacesList' => [ 'type' => 'list', 'member' => [ 'shape' => 'Namespace', ], 'min' => 1, ], 'NetworkConfiguration' => [ 'type' => 'structure', 'required' => [ 'networkMode', ], 'members' => [ 'networkMode' => [ 'shape' => 'NetworkMode', ], 'networkModeConfig' => [ 'shape' => 'VpcConfig', ], ], ], 'NetworkMode' => [ 'type' => 'string', 'enum' => [ 'PUBLIC', 'VPC', ], ], 'NextToken' => [ 'type' => 'string', 'max' => 2048, 'min' => 1, 'pattern' => '\\S*', ], 'NonBlankString' => [ 'type' => 'string', 'pattern' => '[\\s\\S]+', ], 'OAuthCredentialProvider' => [ 'type' => 'structure', 'required' => [ 'providerArn', 'scopes', ], 'members' => [ 'providerArn' => [ 'shape' => 'OAuthCredentialProviderArn', ], 'scopes' => [ 'shape' => 'OAuthScopes', ], 'customParameters' => [ 'shape' => 'OAuthCustomParameters', ], ], ], 'OAuthCredentialProviderArn' => [ 'type' => 'string', 'pattern' => 'arn:([^:]*):([^:]*):([^:]*):([0-9]{12})?:(.+)', ], 'OAuthCustomParameters' => [ 'type' => 'map', 'key' => [ 'shape' => 'OAuthCustomParametersKey', ], 'value' => [ 'shape' => 'OAuthCustomParametersValue', ], 'max' => 10, 'min' => 1, ], 'OAuthCustomParametersKey' => [ 'type' => 'string', 'max' => 256, 'min' => 1, ], 'OAuthCustomParametersValue' => [ 'type' => 'string', 'max' => 2048, 'min' => 1, 'sensitive' => true, ], 'OAuthScope' => [ 'type' => 'string', 'max' => 64, 'min' => 1, ], 'OAuthScopes' => [ 'type' => 'list', 'member' => [ 'shape' => 'OAuthScope', ], 'max' => 100, 'min' => 0, ], 'Oauth2AuthorizationServerMetadata' => [ 'type' => 'structure', 'required' => [ 'issuer', 'authorizationEndpoint', 'tokenEndpoint', ], 'members' => [ 'issuer' => [ 'shape' => 'IssuerUrlType', ], 'authorizationEndpoint' => [ 'shape' => 'AuthorizationEndpointType', ], 'tokenEndpoint' => [ 'shape' => 'TokenEndpointType', ], 'responseTypes' => [ 'shape' => 'ResponseListType', ], 'tokenEndpointAuthMethods' => [ 'shape' => 'TokenEndpointAuthMethodsType', ], ], ], 'Oauth2CredentialProviderItem' => [ 'type' => 'structure', 'required' => [ 'name', 'credentialProviderVendor', 'credentialProviderArn', 'createdTime', 'lastUpdatedTime', ], 'members' => [ 'name' => [ 'shape' => 'CredentialProviderName', ], 'credentialProviderVendor' => [ 'shape' => 'CredentialProviderVendorType', ], 'credentialProviderArn' => [ 'shape' => 'CredentialProviderArnType', ], 'createdTime' => [ 'shape' => 'Timestamp', ], 'lastUpdatedTime' => [ 'shape' => 'Timestamp', ], ], ], 'Oauth2CredentialProviders' => [ 'type' => 'list', 'member' => [ 'shape' => 'Oauth2CredentialProviderItem', ], ], 'Oauth2Discovery' => [ 'type' => 'structure', 'members' => [ 'discoveryUrl' => [ 'shape' => 'DiscoveryUrlType', ], 'authorizationServerMetadata' => [ 'shape' => 'Oauth2AuthorizationServerMetadata', ], ], 'union' => true, ], 'Oauth2ProviderConfigInput' => [ 'type' => 'structure', 'members' => [ 'customOauth2ProviderConfig' => [ 'shape' => 'CustomOauth2ProviderConfigInput', ], 'googleOauth2ProviderConfig' => [ 'shape' => 'GoogleOauth2ProviderConfigInput', ], 'githubOauth2ProviderConfig' => [ 'shape' => 'GithubOauth2ProviderConfigInput', ], 'slackOauth2ProviderConfig' => [ 'shape' => 'SlackOauth2ProviderConfigInput', ], 'salesforceOauth2ProviderConfig' => [ 'shape' => 'SalesforceOauth2ProviderConfigInput', ], 'microsoftOauth2ProviderConfig' => [ 'shape' => 'MicrosoftOauth2ProviderConfigInput', ], 'atlassianOauth2ProviderConfig' => [ 'shape' => 'AtlassianOauth2ProviderConfigInput', ], 'linkedinOauth2ProviderConfig' => [ 'shape' => 'LinkedinOauth2ProviderConfigInput', ], 'includedOauth2ProviderConfig' => [ 'shape' => 'IncludedOauth2ProviderConfigInput', ], ], 'union' => true, ], 'Oauth2ProviderConfigOutput' => [ 'type' => 'structure', 'members' => [ 'customOauth2ProviderConfig' => [ 'shape' => 'CustomOauth2ProviderConfigOutput', ], 'googleOauth2ProviderConfig' => [ 'shape' => 'GoogleOauth2ProviderConfigOutput', ], 'githubOauth2ProviderConfig' => [ 'shape' => 'GithubOauth2ProviderConfigOutput', ], 'slackOauth2ProviderConfig' => [ 'shape' => 'SlackOauth2ProviderConfigOutput', ], 'salesforceOauth2ProviderConfig' => [ 'shape' => 'SalesforceOauth2ProviderConfigOutput', ], 'microsoftOauth2ProviderConfig' => [ 'shape' => 'MicrosoftOauth2ProviderConfigOutput', ], 'atlassianOauth2ProviderConfig' => [ 'shape' => 'AtlassianOauth2ProviderConfigOutput', ], 'linkedinOauth2ProviderConfig' => [ 'shape' => 'LinkedinOauth2ProviderConfigOutput', ], 'includedOauth2ProviderConfig' => [ 'shape' => 'IncludedOauth2ProviderConfigOutput', ], ], 'union' => true, ], 'OverrideType' => [ 'type' => 'string', 'enum' => [ 'SEMANTIC_OVERRIDE', 'SUMMARY_OVERRIDE', 'USER_PREFERENCE_OVERRIDE', 'SELF_MANAGED', ], ], 'Prompt' => [ 'type' => 'string', 'max' => 30000, 'min' => 1, 'sensitive' => true, ], 'ProtocolConfiguration' => [ 'type' => 'structure', 'required' => [ 'serverProtocol', ], 'members' => [ 'serverProtocol' => [ 'shape' => 'ServerProtocol', ], ], ], 'RecordingConfig' => [ 'type' => 'structure', 'members' => [ 'enabled' => [ 'shape' => 'Boolean', ], 's3Location' => [ 'shape' => 'S3Location', ], ], ], 'RequestHeaderAllowlist' => [ 'type' => 'list', 'member' => [ 'shape' => 'HeaderName', ], 'max' => 20, 'min' => 1, ], 'RequestHeaderConfiguration' => [ 'type' => 'structure', 'members' => [ 'requestHeaderAllowlist' => [ 'shape' => 'RequestHeaderAllowlist', ], ], 'union' => true, ], 'RequiredProperties' => [ 'type' => 'list', 'member' => [ 'shape' => 'String', ], ], 'ResourceLimitExceededException' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'String', ], ], 'error' => [ 'httpStatusCode' => 400, 'senderFault' => true, ], 'exception' => true, ], 'ResourceNotFoundException' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'NonBlankString', ], ], 'error' => [ 'httpStatusCode' => 404, 'senderFault' => true, ], 'exception' => true, ], 'ResourceOauth2ReturnUrlListType' => [ 'type' => 'list', 'member' => [ 'shape' => 'ResourceOauth2ReturnUrlType', ], ], 'ResourceOauth2ReturnUrlType' => [ 'type' => 'string', 'max' => 2048, 'min' => 1, 'pattern' => '\\w+:(\\/?\\/?)[^\\s]+', ], 'ResourceType' => [ 'type' => 'string', 'enum' => [ 'SYSTEM', 'CUSTOM', ], ], 'ResponseListType' => [ 'type' => 'list', 'member' => [ 'shape' => 'ResponseType', ], ], 'ResponseType' => [ 'type' => 'string', ], 'RoleArn' => [ 'type' => 'string', 'max' => 2048, 'min' => 1, 'pattern' => 'arn:aws(-[^:]+)?:iam::([0-9]{12})?:role/.+', ], 'RuntimeContainerUri' => [ 'type' => 'string', 'max' => 1024, 'min' => 1, 'pattern' => '([0-9]{12})\\.dkr\\.ecr\\.([a-z0-9-]+)\\.amazonaws\\.com/((?:[a-z0-9]+(?:[._-][a-z0-9]+)*/)*[a-z0-9]+(?:[._-][a-z0-9]+)*)(?::([^:@]{1,300}))?(?:@(.+))?', ], 'S3BucketUri' => [ 'type' => 'string', 'pattern' => 's3://.{1,2043}', ], 'S3Configuration' => [ 'type' => 'structure', 'members' => [ 'uri' => [ 'shape' => 'S3BucketUri', ], 'bucketOwnerAccountId' => [ 'shape' => 'AwsAccountId', ], ], ], 'S3Location' => [ 'type' => 'structure', 'required' => [ 'bucket', 'prefix', ], 'members' => [ 'bucket' => [ 'shape' => 'S3LocationBucketString', ], 'prefix' => [ 'shape' => 'S3LocationPrefixString', ], 'versionId' => [ 'shape' => 'S3LocationVersionIdString', ], ], ], 'S3LocationBucketString' => [ 'type' => 'string', 'pattern' => '[a-z0-9][a-z0-9.-]{1,61}[a-z0-9]', ], 'S3LocationPrefixString' => [ 'type' => 'string', 'max' => 1024, 'min' => 1, ], 'S3LocationVersionIdString' => [ 'type' => 'string', 'max' => 1024, 'min' => 3, ], 'SalesforceOauth2ProviderConfigInput' => [ 'type' => 'structure', 'required' => [ 'clientId', 'clientSecret', ], 'members' => [ 'clientId' => [ 'shape' => 'ClientIdType', ], 'clientSecret' => [ 'shape' => 'ClientSecretType', ], ], ], 'SalesforceOauth2ProviderConfigOutput' => [ 'type' => 'structure', 'required' => [ 'oauthDiscovery', ], 'members' => [ 'oauthDiscovery' => [ 'shape' => 'Oauth2Discovery', ], 'clientId' => [ 'shape' => 'ClientIdType', ], ], ], 'SandboxName' => [ 'type' => 'string', 'pattern' => '[a-zA-Z][a-zA-Z0-9_]{0,47}', ], 'SchemaDefinition' => [ 'type' => 'structure', 'required' => [ 'type', ], 'members' => [ 'type' => [ 'shape' => 'SchemaType', ], 'properties' => [ 'shape' => 'SchemaProperties', ], 'required' => [ 'shape' => 'RequiredProperties', ], 'items' => [ 'shape' => 'SchemaDefinition', ], 'description' => [ 'shape' => 'String', ], ], ], 'SchemaProperties' => [ 'type' => 'map', 'key' => [ 'shape' => 'String', ], 'value' => [ 'shape' => 'SchemaDefinition', ], ], 'SchemaType' => [ 'type' => 'string', 'enum' => [ 'string', 'number', 'object', 'array', 'boolean', 'integer', ], ], 'SearchType' => [ 'type' => 'string', 'enum' => [ 'SEMANTIC', ], ], 'Secret' => [ 'type' => 'structure', 'required' => [ 'secretArn', ], 'members' => [ 'secretArn' => [ 'shape' => 'SecretArn', ], ], ], 'SecretArn' => [ 'type' => 'string', 'pattern' => 'arn:(aws|aws-us-gov):secretsmanager:[A-Za-z0-9-]{1,64}:[0-9]{12}:secret:[a-zA-Z0-9-_/+=.@!]+', ], 'SecurityGroupId' => [ 'type' => 'string', 'pattern' => 'sg-[0-9a-zA-Z]{8,17}', ], 'SecurityGroups' => [ 'type' => 'list', 'member' => [ 'shape' => 'SecurityGroupId', ], 'max' => 16, 'min' => 1, ], 'SelfManagedConfiguration' => [ 'type' => 'structure', 'required' => [ 'triggerConditions', 'invocationConfiguration', 'historicalContextWindowSize', ], 'members' => [ 'triggerConditions' => [ 'shape' => 'TriggerConditionsList', ], 'invocationConfiguration' => [ 'shape' => 'InvocationConfiguration', ], 'historicalContextWindowSize' => [ 'shape' => 'Integer', ], ], ], 'SelfManagedConfigurationInput' => [ 'type' => 'structure', 'required' => [ 'invocationConfiguration', ], 'members' => [ 'triggerConditions' => [ 'shape' => 'TriggerConditionInputList', ], 'invocationConfiguration' => [ 'shape' => 'InvocationConfigurationInput', ], 'historicalContextWindowSize' => [ 'shape' => 'SelfManagedConfigurationInputHistoricalContextWindowSizeInteger', ], ], ], 'SelfManagedConfigurationInputHistoricalContextWindowSizeInteger' => [ 'type' => 'integer', 'box' => true, 'max' => 50, 'min' => 0, ], 'SemanticConsolidationOverride' => [ 'type' => 'structure', 'required' => [ 'appendToPrompt', 'modelId', ], 'members' => [ 'appendToPrompt' => [ 'shape' => 'Prompt', ], 'modelId' => [ 'shape' => 'String', ], ], ], 'SemanticExtractionOverride' => [ 'type' => 'structure', 'required' => [ 'appendToPrompt', 'modelId', ], 'members' => [ 'appendToPrompt' => [ 'shape' => 'Prompt', ], 'modelId' => [ 'shape' => 'String', ], ], ], 'SemanticMemoryStrategyInput' => [ 'type' => 'structure', 'required' => [ 'name', ], 'members' => [ 'name' => [ 'shape' => 'Name', ], 'description' => [ 'shape' => 'Description', ], 'namespaces' => [ 'shape' => 'NamespacesList', ], ], ], 'SemanticOverrideConfigurationInput' => [ 'type' => 'structure', 'members' => [ 'extraction' => [ 'shape' => 'SemanticOverrideExtractionConfigurationInput', ], 'consolidation' => [ 'shape' => 'SemanticOverrideConsolidationConfigurationInput', ], ], ], 'SemanticOverrideConsolidationConfigurationInput' => [ 'type' => 'structure', 'required' => [ 'appendToPrompt', 'modelId', ], 'members' => [ 'appendToPrompt' => [ 'shape' => 'Prompt', ], 'modelId' => [ 'shape' => 'String', ], ], ], 'SemanticOverrideExtractionConfigurationInput' => [ 'type' => 'structure', 'required' => [ 'appendToPrompt', 'modelId', ], 'members' => [ 'appendToPrompt' => [ 'shape' => 'Prompt', ], 'modelId' => [ 'shape' => 'String', ], ], ], 'ServerProtocol' => [ 'type' => 'string', 'enum' => [ 'MCP', 'HTTP', 'A2A', ], ], 'ServiceException' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'String', ], ], 'error' => [ 'httpStatusCode' => 500, ], 'exception' => true, 'fault' => true, 'retryable' => [ 'throttling' => false, ], ], 'ServiceQuotaExceededException' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'NonBlankString', ], ], 'error' => [ 'httpStatusCode' => 402, 'senderFault' => true, ], 'exception' => true, ], 'SetTokenVaultCMKRequest' => [ 'type' => 'structure', 'required' => [ 'kmsConfiguration', ], 'members' => [ 'tokenVaultId' => [ 'shape' => 'TokenVaultIdType', ], 'kmsConfiguration' => [ 'shape' => 'KmsConfiguration', ], ], ], 'SetTokenVaultCMKResponse' => [ 'type' => 'structure', 'required' => [ 'tokenVaultId', 'kmsConfiguration', 'lastModifiedDate', ], 'members' => [ 'tokenVaultId' => [ 'shape' => 'TokenVaultIdType', ], 'kmsConfiguration' => [ 'shape' => 'KmsConfiguration', ], 'lastModifiedDate' => [ 'shape' => 'Timestamp', ], ], ], 'SlackOauth2ProviderConfigInput' => [ 'type' => 'structure', 'required' => [ 'clientId', 'clientSecret', ], 'members' => [ 'clientId' => [ 'shape' => 'ClientIdType', ], 'clientSecret' => [ 'shape' => 'ClientSecretType', ], ], ], 'SlackOauth2ProviderConfigOutput' => [ 'type' => 'structure', 'required' => [ 'oauthDiscovery', ], 'members' => [ 'oauthDiscovery' => [ 'shape' => 'Oauth2Discovery', ], 'clientId' => [ 'shape' => 'ClientIdType', ], ], ], 'StatusReason' => [ 'type' => 'string', 'max' => 2048, 'min' => 0, ], 'StatusReasons' => [ 'type' => 'list', 'member' => [ 'shape' => 'StatusReason', ], 'max' => 100, 'min' => 0, ], 'StrategyConfiguration' => [ 'type' => 'structure', 'members' => [ 'type' => [ 'shape' => 'OverrideType', ], 'extraction' => [ 'shape' => 'ExtractionConfiguration', ], 'consolidation' => [ 'shape' => 'ConsolidationConfiguration', ], 'selfManagedConfiguration' => [ 'shape' => 'SelfManagedConfiguration', ], ], ], 'String' => [ 'type' => 'string', ], 'SubnetId' => [ 'type' => 'string', 'pattern' => 'subnet-[0-9a-zA-Z]{8,17}', ], 'Subnets' => [ 'type' => 'list', 'member' => [ 'shape' => 'SubnetId', ], 'max' => 16, 'min' => 1, ], 'SummaryConsolidationOverride' => [ 'type' => 'structure', 'required' => [ 'appendToPrompt', 'modelId', ], 'members' => [ 'appendToPrompt' => [ 'shape' => 'Prompt', ], 'modelId' => [ 'shape' => 'String', ], ], ], 'SummaryMemoryStrategyInput' => [ 'type' => 'structure', 'required' => [ 'name', ], 'members' => [ 'name' => [ 'shape' => 'Name', ], 'description' => [ 'shape' => 'Description', ], 'namespaces' => [ 'shape' => 'NamespacesList', ], ], ], 'SummaryOverrideConfigurationInput' => [ 'type' => 'structure', 'members' => [ 'consolidation' => [ 'shape' => 'SummaryOverrideConsolidationConfigurationInput', ], ], ], 'SummaryOverrideConsolidationConfigurationInput' => [ 'type' => 'structure', 'required' => [ 'appendToPrompt', 'modelId', ], 'members' => [ 'appendToPrompt' => [ 'shape' => 'Prompt', ], 'modelId' => [ 'shape' => 'String', ], ], ], 'SynchronizeGatewayTargetsRequest' => [ 'type' => 'structure', 'required' => [ 'gatewayIdentifier', 'targetIdList', ], 'members' => [ 'gatewayIdentifier' => [ 'shape' => 'GatewayIdentifier', 'location' => 'uri', 'locationName' => 'gatewayIdentifier', ], 'targetIdList' => [ 'shape' => 'TargetIdList', ], ], ], 'SynchronizeGatewayTargetsResponse' => [ 'type' => 'structure', 'members' => [ 'targets' => [ 'shape' => 'GatewayTargetList', ], ], ], 'TagKey' => [ 'type' => 'string', 'max' => 128, 'min' => 1, 'pattern' => '[a-zA-Z0-9\\s._:/=+@-]*', ], 'TagKeyList' => [ 'type' => 'list', 'member' => [ 'shape' => 'TagKey', ], 'max' => 200, 'min' => 0, ], 'TagResourceRequest' => [ 'type' => 'structure', 'required' => [ 'resourceArn', 'tags', ], 'members' => [ 'resourceArn' => [ 'shape' => 'TaggableResourcesArn', 'location' => 'uri', 'locationName' => 'resourceArn', ], 'tags' => [ 'shape' => 'TagsMap', ], ], ], 'TagResourceResponse' => [ 'type' => 'structure', 'members' => [], ], 'TagValue' => [ 'type' => 'string', 'max' => 256, 'min' => 0, 'pattern' => '[a-zA-Z0-9\\s._:/=+@-]*', ], 'TaggableResourcesArn' => [ 'type' => 'string', 'max' => 1011, 'min' => 20, 'pattern' => 'arn:(?:[^:]+)?:bedrock-agentcore:[a-z0-9-]+:[0-9]{12}:([a-z-]+/[^/]+)(?:/[a-z-]+/[^/]+)*', ], 'TagsMap' => [ 'type' => 'map', 'key' => [ 'shape' => 'TagKey', ], 'value' => [ 'shape' => 'TagValue', ], 'max' => 50, 'min' => 0, ], 'TargetConfiguration' => [ 'type' => 'structure', 'members' => [ 'mcp' => [ 'shape' => 'McpTargetConfiguration', ], ], 'union' => true, ], 'TargetDescription' => [ 'type' => 'string', 'max' => 200, 'min' => 1, 'sensitive' => true, ], 'TargetId' => [ 'type' => 'string', 'pattern' => '[0-9a-zA-Z]{10}', ], 'TargetIdList' => [ 'type' => 'list', 'member' => [ 'shape' => 'TargetId', ], 'max' => 1, 'min' => 1, ], 'TargetMaxResults' => [ 'type' => 'integer', 'box' => true, 'max' => 1000, 'min' => 1, ], 'TargetName' => [ 'type' => 'string', 'pattern' => '([0-9a-zA-Z][-]?){1,100}', 'sensitive' => true, ], 'TargetNextToken' => [ 'type' => 'string', 'max' => 2048, 'min' => 1, 'pattern' => '\\S*', ], 'TargetStatus' => [ 'type' => 'string', 'enum' => [ 'CREATING', 'UPDATING', 'UPDATE_UNSUCCESSFUL', 'DELETING', 'READY', 'FAILED', 'SYNCHRONIZING', 'SYNCHRONIZE_UNSUCCESSFUL', ], ], 'TargetSummaries' => [ 'type' => 'list', 'member' => [ 'shape' => 'TargetSummary', ], ], 'TargetSummary' => [ 'type' => 'structure', 'required' => [ 'targetId', 'name', 'status', 'createdAt', 'updatedAt', ], 'members' => [ 'targetId' => [ 'shape' => 'TargetId', ], 'name' => [ 'shape' => 'TargetName', ], 'status' => [ 'shape' => 'TargetStatus', ], 'description' => [ 'shape' => 'TargetDescription', ], 'createdAt' => [ 'shape' => 'DateTimestamp', ], 'updatedAt' => [ 'shape' => 'DateTimestamp', ], ], ], 'TenantIdType' => [ 'type' => 'string', 'max' => 2048, 'min' => 1, ], 'ThrottledException' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'String', ], ], 'error' => [ 'httpStatusCode' => 429, 'senderFault' => true, ], 'exception' => true, 'retryable' => [ 'throttling' => false, ], ], 'ThrottlingException' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'NonBlankString', ], ], 'error' => [ 'httpStatusCode' => 429, 'senderFault' => true, ], 'exception' => true, ], 'TimeBasedTrigger' => [ 'type' => 'structure', 'members' => [ 'idleSessionTimeout' => [ 'shape' => 'Integer', ], ], ], 'TimeBasedTriggerInput' => [ 'type' => 'structure', 'members' => [ 'idleSessionTimeout' => [ 'shape' => 'TimeBasedTriggerInputIdleSessionTimeoutInteger', ], ], ], 'TimeBasedTriggerInputIdleSessionTimeoutInteger' => [ 'type' => 'integer', 'box' => true, 'max' => 3000, 'min' => 10, ], 'Timestamp' => [ 'type' => 'timestamp', ], 'TokenAuthMethod' => [ 'type' => 'string', 'pattern' => '(client_secret_post|client_secret_basic)', ], 'TokenBasedTrigger' => [ 'type' => 'structure', 'members' => [ 'tokenCount' => [ 'shape' => 'Integer', ], ], ], 'TokenBasedTriggerInput' => [ 'type' => 'structure', 'members' => [ 'tokenCount' => [ 'shape' => 'TokenBasedTriggerInputTokenCountInteger', ], ], ], 'TokenBasedTriggerInputTokenCountInteger' => [ 'type' => 'integer', 'box' => true, 'max' => 500000, 'min' => 100, ], 'TokenEndpointAuthMethodsType' => [ 'type' => 'list', 'member' => [ 'shape' => 'TokenAuthMethod', ], 'max' => 2, 'min' => 1, ], 'TokenEndpointType' => [ 'type' => 'string', ], 'TokenVaultIdType' => [ 'type' => 'string', 'max' => 64, 'min' => 1, 'pattern' => '[a-zA-Z0-9\\-_]+', ], 'ToolDefinition' => [ 'type' => 'structure', 'required' => [ 'name', 'description', 'inputSchema', ], 'members' => [ 'name' => [ 'shape' => 'String', ], 'description' => [ 'shape' => 'String', ], 'inputSchema' => [ 'shape' => 'SchemaDefinition', ], 'outputSchema' => [ 'shape' => 'SchemaDefinition', ], ], ], 'ToolDefinitions' => [ 'type' => 'list', 'member' => [ 'shape' => 'ToolDefinition', ], ], 'ToolSchema' => [ 'type' => 'structure', 'members' => [ 's3' => [ 'shape' => 'S3Configuration', ], 'inlinePayload' => [ 'shape' => 'ToolDefinitions', ], ], 'union' => true, ], 'TriggerCondition' => [ 'type' => 'structure', 'members' => [ 'messageBasedTrigger' => [ 'shape' => 'MessageBasedTrigger', ], 'tokenBasedTrigger' => [ 'shape' => 'TokenBasedTrigger', ], 'timeBasedTrigger' => [ 'shape' => 'TimeBasedTrigger', ], ], 'union' => true, ], 'TriggerConditionInput' => [ 'type' => 'structure', 'members' => [ 'messageBasedTrigger' => [ 'shape' => 'MessageBasedTriggerInput', ], 'tokenBasedTrigger' => [ 'shape' => 'TokenBasedTriggerInput', ], 'timeBasedTrigger' => [ 'shape' => 'TimeBasedTriggerInput', ], ], 'union' => true, ], 'TriggerConditionInputList' => [ 'type' => 'list', 'member' => [ 'shape' => 'TriggerConditionInput', ], 'min' => 1, ], 'TriggerConditionsList' => [ 'type' => 'list', 'member' => [ 'shape' => 'TriggerCondition', ], 'min' => 1, ], 'UnauthorizedException' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'NonBlankString', ], ], 'error' => [ 'httpStatusCode' => 401, 'senderFault' => true, ], 'exception' => true, ], 'UntagResourceRequest' => [ 'type' => 'structure', 'required' => [ 'resourceArn', 'tagKeys', ], 'members' => [ 'resourceArn' => [ 'shape' => 'TaggableResourcesArn', 'location' => 'uri', 'locationName' => 'resourceArn', ], 'tagKeys' => [ 'shape' => 'TagKeyList', 'location' => 'querystring', 'locationName' => 'tagKeys', ], ], ], 'UntagResourceResponse' => [ 'type' => 'structure', 'members' => [], ], 'UpdateAgentRuntimeEndpointRequest' => [ 'type' => 'structure', 'required' => [ 'agentRuntimeId', 'endpointName', ], 'members' => [ 'agentRuntimeId' => [ 'shape' => 'AgentRuntimeId', 'location' => 'uri', 'locationName' => 'agentRuntimeId', ], 'endpointName' => [ 'shape' => 'EndpointName', 'location' => 'uri', 'locationName' => 'endpointName', ], 'agentRuntimeVersion' => [ 'shape' => 'AgentRuntimeVersion', ], 'description' => [ 'shape' => 'AgentEndpointDescription', ], 'clientToken' => [ 'shape' => 'ClientToken', 'idempotencyToken' => true, ], ], ], 'UpdateAgentRuntimeEndpointResponse' => [ 'type' => 'structure', 'required' => [ 'agentRuntimeEndpointArn', 'agentRuntimeArn', 'status', 'createdAt', 'lastUpdatedAt', ], 'members' => [ 'liveVersion' => [ 'shape' => 'AgentRuntimeVersion', ], 'targetVersion' => [ 'shape' => 'AgentRuntimeVersion', ], 'agentRuntimeEndpointArn' => [ 'shape' => 'AgentRuntimeEndpointArn', ], 'agentRuntimeArn' => [ 'shape' => 'AgentRuntimeArn', ], 'status' => [ 'shape' => 'AgentRuntimeEndpointStatus', ], 'createdAt' => [ 'shape' => 'DateTimestamp', ], 'lastUpdatedAt' => [ 'shape' => 'DateTimestamp', ], ], ], 'UpdateAgentRuntimeRequest' => [ 'type' => 'structure', 'required' => [ 'agentRuntimeId', 'agentRuntimeArtifact', 'roleArn', 'networkConfiguration', ], 'members' => [ 'agentRuntimeId' => [ 'shape' => 'AgentRuntimeId', 'location' => 'uri', 'locationName' => 'agentRuntimeId', ], 'agentRuntimeArtifact' => [ 'shape' => 'AgentRuntimeArtifact', ], 'roleArn' => [ 'shape' => 'RoleArn', ], 'networkConfiguration' => [ 'shape' => 'NetworkConfiguration', ], 'description' => [ 'shape' => 'Description', ], 'authorizerConfiguration' => [ 'shape' => 'AuthorizerConfiguration', ], 'requestHeaderConfiguration' => [ 'shape' => 'RequestHeaderConfiguration', ], 'protocolConfiguration' => [ 'shape' => 'ProtocolConfiguration', ], 'lifecycleConfiguration' => [ 'shape' => 'LifecycleConfiguration', ], 'environmentVariables' => [ 'shape' => 'EnvironmentVariablesMap', ], 'clientToken' => [ 'shape' => 'ClientToken', 'idempotencyToken' => true, ], ], ], 'UpdateAgentRuntimeResponse' => [ 'type' => 'structure', 'required' => [ 'agentRuntimeArn', 'agentRuntimeId', 'agentRuntimeVersion', 'createdAt', 'lastUpdatedAt', 'status', ], 'members' => [ 'agentRuntimeArn' => [ 'shape' => 'AgentRuntimeArn', ], 'agentRuntimeId' => [ 'shape' => 'AgentRuntimeId', ], 'workloadIdentityDetails' => [ 'shape' => 'WorkloadIdentityDetails', ], 'agentRuntimeVersion' => [ 'shape' => 'AgentRuntimeVersion', ], 'createdAt' => [ 'shape' => 'DateTimestamp', ], 'lastUpdatedAt' => [ 'shape' => 'DateTimestamp', ], 'status' => [ 'shape' => 'AgentRuntimeStatus', ], ], ], 'UpdateApiKeyCredentialProviderRequest' => [ 'type' => 'structure', 'required' => [ 'name', 'apiKey', ], 'members' => [ 'name' => [ 'shape' => 'CredentialProviderName', ], 'apiKey' => [ 'shape' => 'ApiKeyType', ], ], ], 'UpdateApiKeyCredentialProviderResponse' => [ 'type' => 'structure', 'required' => [ 'apiKeySecretArn', 'name', 'credentialProviderArn', 'createdTime', 'lastUpdatedTime', ], 'members' => [ 'apiKeySecretArn' => [ 'shape' => 'Secret', ], 'name' => [ 'shape' => 'CredentialProviderName', ], 'credentialProviderArn' => [ 'shape' => 'ApiKeyCredentialProviderArnType', ], 'createdTime' => [ 'shape' => 'Timestamp', ], 'lastUpdatedTime' => [ 'shape' => 'Timestamp', ], ], ], 'UpdateGatewayRequest' => [ 'type' => 'structure', 'required' => [ 'gatewayIdentifier', 'name', 'roleArn', 'protocolType', 'authorizerType', ], 'members' => [ 'gatewayIdentifier' => [ 'shape' => 'GatewayIdentifier', 'location' => 'uri', 'locationName' => 'gatewayIdentifier', ], 'name' => [ 'shape' => 'GatewayName', ], 'description' => [ 'shape' => 'GatewayDescription', ], 'roleArn' => [ 'shape' => 'RoleArn', ], 'protocolType' => [ 'shape' => 'GatewayProtocolType', ], 'protocolConfiguration' => [ 'shape' => 'GatewayProtocolConfiguration', ], 'authorizerType' => [ 'shape' => 'AuthorizerType', ], 'authorizerConfiguration' => [ 'shape' => 'AuthorizerConfiguration', ], 'kmsKeyArn' => [ 'shape' => 'KmsKeyArn', ], 'interceptorConfigurations' => [ 'shape' => 'GatewayInterceptorConfigurations', ], 'exceptionLevel' => [ 'shape' => 'ExceptionLevel', ], ], ], 'UpdateGatewayResponse' => [ 'type' => 'structure', 'required' => [ 'gatewayArn', 'gatewayId', 'createdAt', 'updatedAt', 'status', 'name', 'protocolType', 'authorizerType', ], 'members' => [ 'gatewayArn' => [ 'shape' => 'GatewayArn', ], 'gatewayId' => [ 'shape' => 'GatewayId', ], 'gatewayUrl' => [ 'shape' => 'GatewayUrl', ], 'createdAt' => [ 'shape' => 'DateTimestamp', ], 'updatedAt' => [ 'shape' => 'DateTimestamp', ], 'status' => [ 'shape' => 'GatewayStatus', ], 'statusReasons' => [ 'shape' => 'StatusReasons', ], 'name' => [ 'shape' => 'GatewayName', ], 'description' => [ 'shape' => 'GatewayDescription', ], 'roleArn' => [ 'shape' => 'RoleArn', ], 'protocolType' => [ 'shape' => 'GatewayProtocolType', ], 'protocolConfiguration' => [ 'shape' => 'GatewayProtocolConfiguration', ], 'authorizerType' => [ 'shape' => 'AuthorizerType', ], 'authorizerConfiguration' => [ 'shape' => 'AuthorizerConfiguration', ], 'kmsKeyArn' => [ 'shape' => 'KmsKeyArn', ], 'interceptorConfigurations' => [ 'shape' => 'GatewayInterceptorConfigurations', ], 'workloadIdentityDetails' => [ 'shape' => 'WorkloadIdentityDetails', ], 'exceptionLevel' => [ 'shape' => 'ExceptionLevel', ], ], ], 'UpdateGatewayTargetRequest' => [ 'type' => 'structure', 'required' => [ 'gatewayIdentifier', 'targetId', 'name', 'targetConfiguration', ], 'members' => [ 'gatewayIdentifier' => [ 'shape' => 'GatewayIdentifier', 'location' => 'uri', 'locationName' => 'gatewayIdentifier', ], 'targetId' => [ 'shape' => 'TargetId', 'location' => 'uri', 'locationName' => 'targetId', ], 'name' => [ 'shape' => 'TargetName', ], 'description' => [ 'shape' => 'TargetDescription', ], 'targetConfiguration' => [ 'shape' => 'TargetConfiguration', ], 'credentialProviderConfigurations' => [ 'shape' => 'CredentialProviderConfigurations', ], ], ], 'UpdateGatewayTargetResponse' => [ 'type' => 'structure', 'required' => [ 'gatewayArn', 'targetId', 'createdAt', 'updatedAt', 'status', 'name', 'targetConfiguration', 'credentialProviderConfigurations', ], 'members' => [ 'gatewayArn' => [ 'shape' => 'GatewayArn', ], 'targetId' => [ 'shape' => 'TargetId', ], 'createdAt' => [ 'shape' => 'DateTimestamp', ], 'updatedAt' => [ 'shape' => 'DateTimestamp', ], 'status' => [ 'shape' => 'TargetStatus', ], 'statusReasons' => [ 'shape' => 'StatusReasons', ], 'name' => [ 'shape' => 'TargetName', ], 'description' => [ 'shape' => 'TargetDescription', ], 'targetConfiguration' => [ 'shape' => 'TargetConfiguration', ], 'credentialProviderConfigurations' => [ 'shape' => 'CredentialProviderConfigurations', ], 'lastSynchronizedAt' => [ 'shape' => 'DateTimestamp', ], ], ], 'UpdateMemoryInput' => [ 'type' => 'structure', 'required' => [ 'memoryId', ], 'members' => [ 'clientToken' => [ 'shape' => 'UpdateMemoryInputClientTokenString', 'idempotencyToken' => true, ], 'memoryId' => [ 'shape' => 'MemoryId', 'location' => 'uri', 'locationName' => 'memoryId', ], 'description' => [ 'shape' => 'Description', ], 'eventExpiryDuration' => [ 'shape' => 'UpdateMemoryInputEventExpiryDurationInteger', ], 'memoryExecutionRoleArn' => [ 'shape' => 'Arn', ], 'memoryStrategies' => [ 'shape' => 'ModifyMemoryStrategies', ], ], ], 'UpdateMemoryInputClientTokenString' => [ 'type' => 'string', 'max' => 500, 'min' => 0, ], 'UpdateMemoryInputEventExpiryDurationInteger' => [ 'type' => 'integer', 'box' => true, 'max' => 365, 'min' => 7, ], 'UpdateMemoryOutput' => [ 'type' => 'structure', 'members' => [ 'memory' => [ 'shape' => 'Memory', ], ], ], 'UpdateOauth2CredentialProviderRequest' => [ 'type' => 'structure', 'required' => [ 'name', 'credentialProviderVendor', 'oauth2ProviderConfigInput', ], 'members' => [ 'name' => [ 'shape' => 'CredentialProviderName', ], 'credentialProviderVendor' => [ 'shape' => 'CredentialProviderVendorType', ], 'oauth2ProviderConfigInput' => [ 'shape' => 'Oauth2ProviderConfigInput', ], ], ], 'UpdateOauth2CredentialProviderResponse' => [ 'type' => 'structure', 'required' => [ 'clientSecretArn', 'name', 'credentialProviderVendor', 'credentialProviderArn', 'oauth2ProviderConfigOutput', 'createdTime', 'lastUpdatedTime', ], 'members' => [ 'clientSecretArn' => [ 'shape' => 'Secret', ], 'name' => [ 'shape' => 'CredentialProviderName', ], 'credentialProviderVendor' => [ 'shape' => 'CredentialProviderVendorType', ], 'credentialProviderArn' => [ 'shape' => 'CredentialProviderArnType', ], 'callbackUrl' => [ 'shape' => 'String', ], 'oauth2ProviderConfigOutput' => [ 'shape' => 'Oauth2ProviderConfigOutput', ], 'createdTime' => [ 'shape' => 'Timestamp', ], 'lastUpdatedTime' => [ 'shape' => 'Timestamp', ], ], ], 'UpdateWorkloadIdentityRequest' => [ 'type' => 'structure', 'required' => [ 'name', ], 'members' => [ 'name' => [ 'shape' => 'WorkloadIdentityNameType', ], 'allowedResourceOauth2ReturnUrls' => [ 'shape' => 'ResourceOauth2ReturnUrlListType', ], ], ], 'UpdateWorkloadIdentityResponse' => [ 'type' => 'structure', 'required' => [ 'name', 'workloadIdentityArn', 'createdTime', 'lastUpdatedTime', ], 'members' => [ 'name' => [ 'shape' => 'WorkloadIdentityNameType', ], 'workloadIdentityArn' => [ 'shape' => 'WorkloadIdentityArnType', ], 'allowedResourceOauth2ReturnUrls' => [ 'shape' => 'ResourceOauth2ReturnUrlListType', ], 'createdTime' => [ 'shape' => 'Timestamp', ], 'lastUpdatedTime' => [ 'shape' => 'Timestamp', ], ], ], 'UserPreferenceConsolidationOverride' => [ 'type' => 'structure', 'required' => [ 'appendToPrompt', 'modelId', ], 'members' => [ 'appendToPrompt' => [ 'shape' => 'Prompt', ], 'modelId' => [ 'shape' => 'String', ], ], ], 'UserPreferenceExtractionOverride' => [ 'type' => 'structure', 'required' => [ 'appendToPrompt', 'modelId', ], 'members' => [ 'appendToPrompt' => [ 'shape' => 'Prompt', ], 'modelId' => [ 'shape' => 'String', ], ], ], 'UserPreferenceMemoryStrategyInput' => [ 'type' => 'structure', 'required' => [ 'name', ], 'members' => [ 'name' => [ 'shape' => 'Name', ], 'description' => [ 'shape' => 'Description', ], 'namespaces' => [ 'shape' => 'NamespacesList', ], ], ], 'UserPreferenceOverrideConfigurationInput' => [ 'type' => 'structure', 'members' => [ 'extraction' => [ 'shape' => 'UserPreferenceOverrideExtractionConfigurationInput', ], 'consolidation' => [ 'shape' => 'UserPreferenceOverrideConsolidationConfigurationInput', ], ], ], 'UserPreferenceOverrideConsolidationConfigurationInput' => [ 'type' => 'structure', 'required' => [ 'appendToPrompt', 'modelId', ], 'members' => [ 'appendToPrompt' => [ 'shape' => 'Prompt', ], 'modelId' => [ 'shape' => 'String', ], ], ], 'UserPreferenceOverrideExtractionConfigurationInput' => [ 'type' => 'structure', 'required' => [ 'appendToPrompt', 'modelId', ], 'members' => [ 'appendToPrompt' => [ 'shape' => 'Prompt', ], 'modelId' => [ 'shape' => 'String', ], ], ], 'ValidationException' => [ 'type' => 'structure', 'required' => [ 'message', 'reason', ], 'members' => [ 'message' => [ 'shape' => 'String', ], 'reason' => [ 'shape' => 'ValidationExceptionReason', ], 'fieldList' => [ 'shape' => 'ValidationExceptionFieldList', ], ], 'error' => [ 'httpStatusCode' => 400, 'senderFault' => true, ], 'exception' => true, ], 'ValidationExceptionField' => [ 'type' => 'structure', 'required' => [ 'name', 'message', ], 'members' => [ 'name' => [ 'shape' => 'String', ], 'message' => [ 'shape' => 'String', ], ], ], 'ValidationExceptionFieldList' => [ 'type' => 'list', 'member' => [ 'shape' => 'ValidationExceptionField', ], ], 'ValidationExceptionReason' => [ 'type' => 'string', 'enum' => [ 'CannotParse', 'FieldValidationFailed', 'IdempotentParameterMismatchException', 'EventInOtherSession', 'ResourceConflict', ], ], 'VpcConfig' => [ 'type' => 'structure', 'required' => [ 'securityGroups', 'subnets', ], 'members' => [ 'securityGroups' => [ 'shape' => 'SecurityGroups', ], 'subnets' => [ 'shape' => 'Subnets', ], ], ], 'WorkloadIdentityArn' => [ 'type' => 'string', 'max' => 1024, 'min' => 1, ], 'WorkloadIdentityArnType' => [ 'type' => 'string', 'max' => 1024, 'min' => 1, ], 'WorkloadIdentityDetails' => [ 'type' => 'structure', 'required' => [ 'workloadIdentityArn', ], 'members' => [ 'workloadIdentityArn' => [ 'shape' => 'WorkloadIdentityArn', ], ], ], 'WorkloadIdentityList' => [ 'type' => 'list', 'member' => [ 'shape' => 'WorkloadIdentityType', ], ], 'WorkloadIdentityNameType' => [ 'type' => 'string', 'max' => 255, 'min' => 3, 'pattern' => '[A-Za-z0-9_.-]+', ], 'WorkloadIdentityType' => [ 'type' => 'structure', 'required' => [ 'name', 'workloadIdentityArn', ], 'members' => [ 'name' => [ 'shape' => 'WorkloadIdentityNameType', ], 'workloadIdentityArn' => [ 'shape' => 'WorkloadIdentityArnType', ], ], ], 'entryPoint' => [ 'type' => 'string', 'max' => 128, 'min' => 1, ], ],];
