<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', current_locale())); ?>">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no,  maximum-scale=1.0">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

    <link rel="icon" type="image/png" sizes="56x56"
        href="<?php echo e(asset(get_option('primary_data')['favicon'] ?? 'favicon.png')); ?>">

    <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Open+Sans:300,400,600,700">

    <meta name="app-name" content="<?php echo e(config('app.name')); ?>" />

    <meta name="app-translations" content="<?php echo e(getTranslationFile()); ?>" />

    <title inertia><?php echo e(config('app.name', 'Laravel')); ?></title>

    <script>
        "use strict"
        if (
            localStorage.getItem('theme') === 'dark' ||
            (!('theme' in localStorage) && window.matchMedia('(prefers-color-scheme: dark)').matches)
        ) {
            document.documentElement.classList.add('dark');
        } else {
            document.documentElement.classList.remove('dark');
        }
    </script>
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/css/custom.css')); ?>" media="all">
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/css/custom-toastr.css')); ?>" media="all">

    <?php
        $activeModule = $page['props']['activeModule'] ?? null;
        $commonCss = ['resources/css/app.css', 'resources/scss/admin/main.scss'];

        $entryPoints = $activeModule
            ? [
                "modules/{$activeModule}/resources/js/app.js",
                "modules/{$activeModule}/resources/js/Pages/{$page['component']}.vue",
                ...$commonCss,
            ]
            : ['resources/js/app.js', ...$commonCss];

        $buildDir = $activeModule ? 'build-modules/' . Str::studly($activeModule) : 'build';
    ?>
    <?php echo app('Illuminate\Foundation\Vite')($entryPoints, $buildDir); ?>

    <?php if (!isset($__inertiaSsrDispatched)) { $__inertiaSsrDispatched = true; $__inertiaSsrResponse = app(\Inertia\Ssr\Gateway::class)->dispatch($page); }  if ($__inertiaSsrResponse) { echo $__inertiaSsrResponse->head; } ?>
    <?php echo app('Tighten\Ziggy\BladeRouteGenerator')->generate(); ?>
</head>

<body>
    <?php if (!isset($__inertiaSsrDispatched)) { $__inertiaSsrDispatched = true; $__inertiaSsrResponse = app(\Inertia\Ssr\Gateway::class)->dispatch($page); }  if ($__inertiaSsrResponse) { echo $__inertiaSsrResponse->body; } else { ?><div id="app" data-page="<?php echo e(json_encode($page)); ?>"></div><?php } ?>
    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(env('COOKIE_CONSENT', false) && !getCookieConsent()): ?>
        <?php echo Whitecube\LaravelCookieConsent\Facades\Cookies::renderView(); ?>
    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
</body>

</html>
<?php /**PATH /Volumes/my-works/laravel/whatsml-live/resources/views/layouts/auth.blade.php ENDPATH**/ ?>