<?php

namespace Modules\WhatsappWeb\App\Providers;

use Illuminate\Foundation\Support\Providers\RouteServiceProvider as ServiceProvider;
use Illuminate\Support\Facades\Route;

class RouteServiceProvider extends ServiceProvider
{
    protected $moduleNamespace = 'Modules\WhatsappWeb\App\Http\Controllers';

    /**
     * Called before routes are registered.
     *
     * Register any model bindings or pattern based filters.
     */
    public function boot(): void
    {
        parent::boot();
    }

    /**
     * Define the routes for the application.
     */
    public function map(): void
    {
        Route::middleware('api')
            ->prefix('api/whatsapp-web')
            ->name('user.whatsapp-web.api.')
            ->namespace($this->moduleNamespace)
            ->group(module_path('WhatsappWeb', '/routes/api.php'));

        Route::middleware('web','auth','check_subscription')
            ->prefix('user/whatsapp-web')
            ->name('user.whatsapp-web.')
            ->namespace($this->moduleNamespace)
            ->group(module_path('WhatsappWeb', '/routes/web.php'));

        Route::prefix('cron/whatsapp-web')
            ->namespace($this->moduleNamespace)
            ->group(module_path('WhatsappWeb', '/routes/cron.php'));
    }
}
