<?php

namespace Modules\Whatsapp\App\Providers;

use Illuminate\Foundation\Support\Providers\RouteServiceProvider as ServiceProvider;
use Illuminate\Support\Facades\Route;

class RouteServiceProvider extends ServiceProvider
{
    /**
     * The module namespace to assume when generating URLs to actions.
     *
     * @var string
     */
    protected $moduleNamespace = 'Modules\Whatsapp\App\Http\Controllers';

    /**
     * Called before routes are registered.
     *
     * Register any model bindings or pattern based filters.
     *
     * @return void
     */
    public function boot()
    {
        parent::boot();
    }

    /**
     * Define the routes for the application.
     *
     * @return void
     */
    public function map()
    {
        Route::middleware(['web', 'auth', 'user','check_subscription', 'access_module:whatsapp'])
            ->prefix('user/whatsapp')
            ->as('user.whatsapp.')
            ->namespace($this->moduleNamespace)
            ->group(module_path('Whatsapp', '/routes/web.php'));

        Route::middleware(['api'])
            ->prefix('api/whatsapp')
            ->as('api.whatsapp.')
            ->namespace($this->moduleNamespace)
            ->group(module_path('Whatsapp', '/routes/api.php'));

        Route::prefix('cron/whatsapp')
            ->as('cron.whatsapp.')
            ->namespace($this->moduleNamespace)
            ->group(module_path('Whatsapp', '/routes/cron.php'));
    }
}
