<?php

namespace Modules\Whatsapp\App\Http\Controllers;

use App\Helpers\PlanPerks;
use App\Http\Controllers\Controller;
use App\Models\Campaign;
use Illuminate\Support\Carbon;
use Modules\Whatsapp\App\Services\CampaignService;

class CronController extends Controller
{
    public function __invoke()
    {
        $now = Carbon::now()->toDateTimeString();

        $scheduledCampaigns = Campaign::query()
            ->whatsapp()
            ->where('status', 'scheduled')
            ->where('schedule_at', '<=', $now)
            ->get();

        $stats = [
            'total' => $scheduledCampaigns->count(),
            'sent' => 0,
            'failed' => 0,
        ];

        if (count($scheduledCampaigns) > 0) {
            Campaign::query()
                ->where('status', 'scheduled')
                ->where('schedule_at', '<=', $now)
                ->update(['status' => 'pending']);

            foreach ($scheduledCampaigns as $campaign) {

                $user = $campaign->owner;
                if (! $user) {
                    $campaign->update(['status' => 'failed']);
                    $stats['failed']++;

                    continue;
                }

                validateUserPlan('campaign', false, $user->id);
                validateUserPlan('cloud_messages', false, $user->id);

                try {

                    $monthCycle = PlanPerks::calculateCurrentCycleUsage($user);
                    $alreadySendMessageCount = $user->messages()->whatsapp()
                        ->whereBetween('created_at', [$monthCycle['start'], $monthCycle['end']])
                        ->count();

                    $messageLimit = data_get($user->plan_data, 'cloud_messages.value', 0);
                    $remainingMessageCount = $messageLimit - $alreadySendMessageCount;
                    $newMessageCount = $user->groups()->whatsapp()->find($campaign->group_id)?->customers()->count();

                    if ($newMessageCount > $remainingMessageCount) {
                        $campaign->update(['status' => 'failed']);
                        $stats['failed']++;

                        continue;
                    }

                    CampaignService::send($campaign);
                    $stats['sent']++;
                } catch (\Throwable $th) {
                    $campaign->update(['status' => 'failed']);
                    $stats['failed']++;
                }
            }
        }

        return response()->json([
            'success' => true,
            'message' => 'Campaigns dispatched successfully',
            'stats' => $stats,
        ]);
    }
}
